/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class CRegistryPredicateArgumentType<T>
implements ArgumentType<RegistryPredicate<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    final class_5321<? extends class_2378<T>> registryRef;

    public CRegistryPredicateArgumentType(class_5321<? extends class_2378<T>> registryRef) {
        this.registryRef = registryRef;
    }

    public static <T> CRegistryPredicateArgumentType<T> registryPredicate(class_5321<? extends class_2378<T>> registryRef) {
        return new CRegistryPredicateArgumentType<T>(registryRef);
    }

    public static <T> RegistryPredicate<T> getCPredicate(CommandContext<FabricClientCommandSource> context, String name, class_5321<class_2378<T>> registryRef, DynamicCommandExceptionType invalidException) throws CommandSyntaxException {
        RegistryPredicate registryPredicate = (RegistryPredicate)context.getArgument(name, RegistryPredicate.class);
        Optional<RegistryPredicate<T>> optional = registryPredicate.tryCast(registryRef);
        return optional.orElseThrow(() -> invalidException.create((Object)registryPredicate));
    }

    public RegistryPredicate<T> parse(StringReader stringReader) throws CommandSyntaxException {
        if (stringReader.canRead() && stringReader.peek() == '#') {
            int i = stringReader.getCursor();
            try {
                stringReader.skip();
                class_2960 identifier = class_2960.method_12835((StringReader)stringReader);
                return new TagBased(class_6862.method_40092(this.registryRef, (class_2960)identifier));
            }
            catch (CommandSyntaxException var4) {
                stringReader.setCursor(i);
                throw var4;
            }
        }
        class_2960 identifier2 = class_2960.method_12835((StringReader)stringReader);
        return new RegistryKeyBased(class_5321.method_29179(this.registryRef, (class_2960)identifier2));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object s = context.getSource();
        if (s instanceof class_2172) {
            class_2172 commandSource = (class_2172)s;
            return commandSource.method_41213(this.registryRef, class_2172.class_7078.field_37264, builder, context);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static interface RegistryPredicate<T>
    extends Predicate<class_6880<T>> {
        public Either<class_5321<T>, class_6862<T>> getKey();

        public <E> Optional<RegistryPredicate<E>> tryCast(class_5321<? extends class_2378<E>> var1);

        public String asString();
    }

    record TagBased<T>(class_6862<T> key) implements RegistryPredicate<T>
    {
        @Override
        public Either<class_5321<T>, class_6862<T>> getKey() {
            return Either.right(this.key);
        }

        @Override
        public <E> Optional<RegistryPredicate<E>> tryCast(class_5321<? extends class_2378<E>> registryRef) {
            return this.key.method_41008(registryRef).map(TagBased::new);
        }

        @Override
        public boolean test(class_6880<T> registryEntry) {
            return registryEntry.method_40220(this.key);
        }

        @Override
        public String asString() {
            return "#" + this.key.comp_327();
        }
    }

    record RegistryKeyBased<T>(class_5321<T> key) implements RegistryPredicate<T>
    {
        @Override
        public Either<class_5321<T>, class_6862<T>> getKey() {
            return Either.left(this.key);
        }

        @Override
        public <E> Optional<RegistryPredicate<E>> tryCast(class_5321<? extends class_2378<E>> registryRef) {
            return this.key.method_39752(registryRef).map(RegistryKeyBased::new);
        }

        @Override
        public boolean test(class_6880<T> registryEntry) {
            return registryEntry.method_40225(this.key);
        }

        @Override
        public String asString() {
            return this.key.method_29177().toString();
        }
    }
}

