/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7733;

public class CRegistryEntryPredicateArgumentType<T>
implements ArgumentType<EntryPredicate<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    private static final Dynamic2CommandExceptionType NOT_FOUND_EXCEPTION = new Dynamic2CommandExceptionType((tag, type) -> class_2561.method_43469((String)"argument.resource_tag.not_found", (Object[])new Object[]{tag, type}));
    private static final Dynamic3CommandExceptionType WRONG_TYPE_EXCEPTION = new Dynamic3CommandExceptionType((tag, type, expectedType) -> class_2561.method_43469((String)"argument.resource_tag.invalid_type", (Object[])new Object[]{tag, type, expectedType}));
    private final class_7225<T> registryWrapper;
    final class_5321<? extends class_2378<T>> registryRef;

    public CRegistryEntryPredicateArgumentType(class_7157 registryAccess, class_5321<? extends class_2378<T>> registryRef) {
        this.registryRef = registryRef;
        this.registryWrapper = registryAccess.method_41699(registryRef);
    }

    public static <T> CRegistryEntryPredicateArgumentType<T> registryEntryPredicate(class_7157 registryRef, class_5321<? extends class_2378<T>> registryAccess) {
        return new CRegistryEntryPredicateArgumentType<T>(registryRef, registryAccess);
    }

    public static <T> EntryPredicate<T> getRegistryEntryPredicate(CommandContext<FabricClientCommandSource> context, String name, class_5321<class_2378<T>> registryRef) throws CommandSyntaxException {
        EntryPredicate entryPredicate = (EntryPredicate)context.getArgument(name, EntryPredicate.class);
        Optional<EntryPredicate<T>> optional = entryPredicate.tryCast(registryRef);
        return optional.orElseThrow(() -> (CommandSyntaxException)((Object)((Object)entryPredicate.getEntry().map(entry -> {
            class_5321 registryKey = entry.method_40237();
            return class_7733.field_40402.create((Object)registryKey.method_29177(), (Object)registryKey.method_41185(), (Object)registryRef.method_29177());
        }, entryList -> {
            class_6862 tagKey = entryList.method_40251();
            return WRONG_TYPE_EXCEPTION.create((Object)tagKey.comp_327(), (Object)tagKey.comp_326(), (Object)registryRef.method_29177());
        }))));
    }

    public EntryPredicate<T> parse(StringReader stringReader) throws CommandSyntaxException {
        if (stringReader.canRead() && stringReader.peek() == '#') {
            int cursor = stringReader.getCursor();
            try {
                stringReader.skip();
                class_2960 identifier = class_2960.method_12835((StringReader)stringReader);
                class_6862 tagKey = class_6862.method_40092(this.registryRef, (class_2960)identifier);
                class_6885.class_6888 named = (class_6885.class_6888)this.registryWrapper.method_46733(tagKey).orElseThrow(() -> NOT_FOUND_EXCEPTION.create((Object)identifier, (Object)this.registryRef.method_29177()));
                return new TagBased(named);
            }
            catch (CommandSyntaxException e) {
                stringReader.setCursor(cursor);
                throw e;
            }
        }
        class_2960 identifier = class_2960.method_12835((StringReader)stringReader);
        class_5321 registryKey = class_5321.method_29179(this.registryRef, (class_2960)identifier);
        class_6880.class_6883 reference = (class_6880.class_6883)this.registryWrapper.method_46746(registryKey).orElseThrow(() -> class_7733.field_40401.create((Object)identifier, (Object)this.registryRef.method_29177()));
        return new EntryBased(reference);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        class_2172.method_40182(this.registryWrapper.method_46755().map(class_6862::comp_327), (SuggestionsBuilder)builder, (String)"#");
        return class_2172.method_9257(this.registryWrapper.method_46754().map(class_5321::method_29177), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static interface EntryPredicate<T>
    extends Predicate<class_6880<T>> {
        public Either<class_6880.class_6883<T>, class_6885.class_6888<T>> getEntry();

        public <E> Optional<EntryPredicate<E>> tryCast(class_5321<? extends class_2378<E>> var1);

        public String asString();
    }

    private record TagBased<T>(class_6885.class_6888<T> tag) implements EntryPredicate<T>
    {
        @Override
        public Either<class_6880.class_6883<T>, class_6885.class_6888<T>> getEntry() {
            return Either.right(this.tag);
        }

        @Override
        public <E> Optional<EntryPredicate<E>> tryCast(class_5321<? extends class_2378<E>> registryRef) {
            return this.tag.method_40251().method_41007(registryRef) ? Optional.of(this) : Optional.empty();
        }

        @Override
        public boolean test(class_6880<T> registryEntry) {
            return this.tag.method_40241(registryEntry);
        }

        @Override
        public String asString() {
            return "#" + this.tag.method_40251().comp_327();
        }
    }

    private record EntryBased<T>(class_6880.class_6883<T> value) implements EntryPredicate<T>
    {
        @Override
        public Either<class_6880.class_6883<T>, class_6885.class_6888<T>> getEntry() {
            return Either.left(this.value);
        }

        @Override
        public <E> Optional<EntryPredicate<E>> tryCast(class_5321<? extends class_2378<E>> registryRef) {
            return this.value.method_40237().method_31163(registryRef) ? Optional.of(this) : Optional.empty();
        }

        @Override
        public boolean test(class_6880<T> registryEntry) {
            return registryEntry.equals(this.value);
        }

        @Override
        public String asString() {
            return this.value.method_40237().method_29177().toString();
        }
    }
}

