/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_267;
import net.minecraft.class_3532;

public class COperationArgumentType
implements ArgumentType<Operation> {
    private static final Collection<String> EXAMPLES = Arrays.asList("=", ">", "<");
    private static final SimpleCommandExceptionType INVALID_OPERATION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"arguments.operation.invalid"));
    private static final SimpleCommandExceptionType DIVISION_ZERO_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"arguments.operation.div0"));

    public static COperationArgumentType operation() {
        return new COperationArgumentType();
    }

    public static Operation getCOperation(CommandContext<FabricClientCommandSource> context, String name) {
        return (Operation)context.getArgument(name, Operation.class);
    }

    public Operation parse(StringReader stringReader) throws CommandSyntaxException {
        if (!stringReader.canRead()) {
            throw INVALID_OPERATION.create();
        }
        int cursor = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        return COperationArgumentType.getOperator(stringReader.getString().substring(cursor, stringReader.getCursor()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9253((String[])new String[]{"=", "+=", "-=", "*=", "/=", "%=", "<", ">", "><"}, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static Operation getOperator(String operator) throws CommandSyntaxException {
        return operator.equals("><") ? (a, b) -> {
            int score = a.method_1126();
            a.method_1128(b.method_1126());
            b.method_1128(score);
        } : COperationArgumentType.getIntOperator(operator);
    }

    private static IntOperator getIntOperator(String operator) throws CommandSyntaxException {
        int code = -1;
        switch (operator.hashCode()) {
            case 60: {
                if (!operator.equals("<")) break;
                code = 6;
                break;
            }
            case 61: {
                if (!operator.equals("=")) break;
                code = 0;
                break;
            }
            case 62: {
                if (!operator.equals(">")) break;
                code = 7;
                break;
            }
            case 1208: {
                if (!operator.equals("%=")) break;
                code = 5;
                break;
            }
            case 1363: {
                if (!operator.equals("*=")) break;
                code = 3;
                break;
            }
            case 1394: {
                if (!operator.equals("+=")) break;
                code = 1;
                break;
            }
            case 1456: {
                if (!operator.equals("-=")) break;
                code = 2;
                break;
            }
            case 1518: {
                if (!operator.equals("/=")) break;
                code = 4;
            }
        }
        return switch (code) {
            case 0 -> (a, b) -> b;
            case 1 -> Integer::sum;
            case 2 -> (a, b) -> a - b;
            case 3 -> (a, b) -> a * b;
            case 4 -> (a, b) -> {
                if (b == 0) {
                    throw DIVISION_ZERO_EXCEPTION.create();
                }
                return class_3532.method_48116((int)a, (int)b);
            };
            case 5 -> (a, b) -> {
                if (b == 0) {
                    throw DIVISION_ZERO_EXCEPTION.create();
                }
                return class_3532.method_15387((int)a, (int)b);
            };
            case 6 -> Math::min;
            case 7 -> Math::max;
            default -> throw INVALID_OPERATION.create();
        };
    }

    @FunctionalInterface
    public static interface Operation {
        public void apply(class_267 var1, class_267 var2) throws CommandSyntaxException;
    }

    @FunctionalInterface
    private static interface IntOperator
    extends Operation {
        public int apply(int var1, int var2) throws CommandSyntaxException;

        @Override
        default public void apply(class_267 scoreboardPlayerScore, class_267 scoreboardPlayerScore2) throws CommandSyntaxException {
            scoreboardPlayerScore.method_1128(this.apply(scoreboardPlayerScore.method_1126(), scoreboardPlayerScore2.method_1126()));
        }
    }
}

