/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CNbtPathArgumentType
implements ArgumentType<NbtPath> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo.bar", "foo[0]", "[0]", "[]", "{foo=bar}");
    public static final SimpleCommandExceptionType INVALID_PATH_NODE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"arguments.nbtpath.node.invalid"));
    public static final DynamicCommandExceptionType NOTHING_FOUND_EXCEPTION = new DynamicCommandExceptionType(path -> class_2561.method_43469((String)"arguments.nbtpath.nothing_found", (Object[])new Object[]{path}));

    public static CNbtPathArgumentType nbtPath() {
        return new CNbtPathArgumentType();
    }

    public static NbtPath getCNbtPath(CommandContext<FabricClientCommandSource> context, String name) {
        return (NbtPath)context.getArgument(name, NbtPath.class);
    }

    public NbtPath parse(StringReader stringReader) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayList();
        int cursor = stringReader.getCursor();
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        boolean bl = true;
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            char c;
            PathNode pathNode = CNbtPathArgumentType.parseNode(stringReader, bl);
            list.add(pathNode);
            object2IntMap.put((Object)pathNode, stringReader.getCursor() - cursor);
            bl = false;
            if (!stringReader.canRead() || (c = stringReader.peek()) == ' ' || c == '[' || c == '{') continue;
            stringReader.expect('.');
        }
        return new NbtPath(stringReader.getString().substring(cursor, stringReader.getCursor()), list.toArray(new PathNode[0]), (Object2IntMap<PathNode>)object2IntMap);
    }

    private static PathNode parseNode(StringReader reader, boolean root) throws CommandSyntaxException {
        switch (reader.peek()) {
            case '\"': {
                return CNbtPathArgumentType.readCompoundChildNode(reader, reader.readString());
            }
            case '[': {
                reader.skip();
                char peek = reader.peek();
                if (peek == '{') {
                    class_2487 nbtCompound2 = new class_2522(reader).method_10727();
                    reader.expect(']');
                    return new FilteredListElementNode(nbtCompound2);
                }
                if (peek == ']') {
                    reader.skip();
                    return AllListElementNode.INSTANCE;
                }
                int j = reader.readInt();
                reader.expect(']');
                return new IndexedListElementNode(j);
            }
            case '{': {
                if (!root) {
                    throw INVALID_PATH_NODE_EXCEPTION.createWithContext((ImmutableStringReader)reader);
                }
                class_2487 nbtCompound = new class_2522(reader).method_10727();
                return new FilteredRootNode(nbtCompound);
            }
        }
        return CNbtPathArgumentType.readCompoundChildNode(reader, CNbtPathArgumentType.readName(reader));
    }

    private static PathNode readCompoundChildNode(StringReader reader, String name) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '{') {
            class_2487 nbtCompound = new class_2522(reader).method_10727();
            return new FilteredNamedNode(name, nbtCompound);
        }
        return new NamedNode(name);
    }

    private static String readName(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        while (reader.canRead() && CNbtPathArgumentType.isNameCharacter(reader.peek())) {
            reader.skip();
        }
        if (reader.getCursor() == cursor) {
            throw INVALID_PATH_NODE_EXCEPTION.createWithContext((ImmutableStringReader)reader);
        }
        return reader.getString().substring(cursor, reader.getCursor());
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static boolean isNameCharacter(char c) {
        return c != ' ' && c != '\"' && c != '[' && c != ']' && c != '.' && c != '{' && c != '}';
    }

    static Predicate<class_2520> getPredicate(class_2487 filter) {
        return nbtElement -> class_2512.method_10687((class_2520)filter, (class_2520)nbtElement, (boolean)true);
    }

    public static class NbtPath {
        private final String string;
        private final Object2IntMap<PathNode> nodeEndIndices;
        private final PathNode[] nodes;

        public NbtPath(String string, PathNode[] nodes, Object2IntMap<PathNode> nodeEndIndices) {
            this.string = string;
            this.nodes = nodes;
            this.nodeEndIndices = nodeEndIndices;
        }

        public List<class_2520> get(class_2520 element) throws CommandSyntaxException {
            List<class_2520> list = Collections.singletonList(element);
            for (PathNode pathNode : this.nodes) {
                if (!(list = pathNode.get(list)).isEmpty()) continue;
                throw this.createNothingFoundException(pathNode);
            }
            return list;
        }

        public int count(class_2520 element) {
            List<class_2520> list = Collections.singletonList(element);
            for (PathNode pathNode : this.nodes) {
                if (!(list = pathNode.get(list)).isEmpty()) continue;
                return 0;
            }
            return list.size();
        }

        private List<class_2520> getTerminals(class_2520 start) throws CommandSyntaxException {
            List<class_2520> list = Collections.singletonList(start);
            for (int i = 0; i < this.nodes.length - 1; ++i) {
                PathNode pathNode = this.nodes[i];
                int j = i + 1;
                PathNode nextPathNode = this.nodes[j];
                Objects.requireNonNull(nextPathNode);
                list = pathNode.getOrInit(list, nextPathNode::init);
                if (!list.isEmpty()) continue;
                throw this.createNothingFoundException(pathNode);
            }
            return list;
        }

        public List<class_2520> getOrInit(class_2520 element, Supplier<class_2520> source) throws CommandSyntaxException {
            List<class_2520> list = this.getTerminals(element);
            PathNode pathNode = this.nodes[this.nodes.length - 1];
            return pathNode.getOrInit(list, source);
        }

        private static int forEach(List<class_2520> elements, Function<class_2520, Integer> operation) {
            return elements.stream().map(operation).reduce(0, Integer::sum);
        }

        public int put(class_2520 element, class_2520 source) throws CommandSyntaxException {
            Objects.requireNonNull(source);
            return this.put(element, () -> ((class_2520)source).method_10707());
        }

        public int put(class_2520 element, Supplier<class_2520> source) throws CommandSyntaxException {
            List<class_2520> list = this.getTerminals(element);
            PathNode pathNode = this.nodes[this.nodes.length - 1];
            return NbtPath.forEach(list, nbt -> pathNode.set((class_2520)nbt, source));
        }

        public int remove(class_2520 element) {
            List<class_2520> list = Collections.singletonList(element);
            for (int i = 0; i < this.nodes.length - 1; ++i) {
                list = this.nodes[i].get(list);
            }
            PathNode pathNode = this.nodes[this.nodes.length - 1];
            Objects.requireNonNull(pathNode);
            return NbtPath.forEach(list, pathNode::clear);
        }

        private CommandSyntaxException createNothingFoundException(PathNode node) {
            int i = this.nodeEndIndices.getInt((Object)node);
            return NOTHING_FOUND_EXCEPTION.create((Object)this.string.substring(0, i));
        }

        public String toString() {
            return this.string;
        }
    }

    private static interface PathNode {
        public void get(class_2520 var1, List<class_2520> var2);

        public void getOrInit(class_2520 var1, Supplier<class_2520> var2, List<class_2520> var3);

        public class_2520 init();

        public int set(class_2520 var1, Supplier<class_2520> var2);

        public int clear(class_2520 var1);

        default public List<class_2520> get(List<class_2520> elements) {
            return this.process(elements, this::get);
        }

        default public List<class_2520> getOrInit(List<class_2520> elements, Supplier<class_2520> supplier) {
            return this.process(elements, (current, results) -> this.getOrInit((class_2520)current, supplier, (List<class_2520>)results));
        }

        default public List<class_2520> process(List<class_2520> elements, BiConsumer<class_2520, List<class_2520>> action) {
            ArrayList list = Lists.newArrayList();
            for (class_2520 nbtElement : elements) {
                action.accept(nbtElement, list);
            }
            return list;
        }
    }

    static class FilteredListElementNode
    implements PathNode {
        private final class_2487 filter;
        private final Predicate<class_2520> predicate;

        public FilteredListElementNode(class_2487 filter) {
            this.filter = filter;
            this.predicate = CNbtPathArgumentType.getPredicate(filter);
        }

        @Override
        public void get(class_2520 current, List<class_2520> results) {
            if (current instanceof class_2499) {
                class_2499 nbtList = (class_2499)current;
                Stream<class_2520> elementStream = nbtList.stream().filter(this.predicate);
                Objects.requireNonNull(results);
                elementStream.forEach(results::add);
            }
        }

        @Override
        public void getOrInit(class_2520 current, Supplier<class_2520> source, List<class_2520> results) {
            MutableBoolean mutableBoolean = new MutableBoolean();
            if (current instanceof class_2499) {
                class_2499 nbtList = (class_2499)current;
                nbtList.stream().filter(this.predicate).forEach(nbt -> {
                    results.add((class_2520)nbt);
                    mutableBoolean.setTrue();
                });
                if (mutableBoolean.isFalse()) {
                    class_2487 nbtCompound = this.filter.method_10553();
                    nbtList.add((Object)nbtCompound);
                    results.add((class_2520)nbtCompound);
                }
            }
        }

        @Override
        public class_2520 init() {
            return new class_2499();
        }

        @Override
        public int set(class_2520 current, Supplier<class_2520> source) {
            int i = 0;
            if (current instanceof class_2499) {
                class_2499 nbtList = (class_2499)current;
                int j = nbtList.size();
                if (j == 0) {
                    nbtList.add((Object)source.get());
                    ++i;
                } else {
                    for (int k = 0; k < j; ++k) {
                        class_2520 nbtElement2;
                        class_2520 nbtElement = nbtList.method_10534(k);
                        if (!this.predicate.test(nbtElement) || (nbtElement2 = source.get()).equals(nbtElement) || !nbtList.method_10535(k, nbtElement2)) continue;
                        ++i;
                    }
                }
            }
            return i;
        }

        @Override
        public int clear(class_2520 current) {
            int i = 0;
            if (current instanceof class_2499) {
                class_2499 nbtList = (class_2499)current;
                for (int j = nbtList.size() - 1; j >= 0; --j) {
                    if (!this.predicate.test(nbtList.method_10534(j))) continue;
                    nbtList.method_10536(j);
                    ++i;
                }
            }
            return i;
        }
    }

    static class AllListElementNode
    implements PathNode {
        public static final AllListElementNode INSTANCE = new AllListElementNode();

        private AllListElementNode() {
        }

        @Override
        public void get(class_2520 current, List<class_2520> results) {
            if (current instanceof class_2483) {
                class_2483 abstractNbtList = (class_2483)current;
                results.add((class_2520)abstractNbtList);
            }
        }

        @Override
        public void getOrInit(class_2520 current, Supplier<class_2520> source, List<class_2520> results) {
            if (current instanceof class_2483) {
                class_2483 abstractNbtList = (class_2483)current;
                if (abstractNbtList.isEmpty()) {
                    class_2520 nbtElement = source.get();
                    if (abstractNbtList.method_10533(0, nbtElement)) {
                        results.add(nbtElement);
                    }
                } else {
                    results.add((class_2520)abstractNbtList);
                }
            }
        }

        @Override
        public class_2520 init() {
            return new class_2499();
        }

        @Override
        public int set(class_2520 current, Supplier<class_2520> source) {
            if (!(current instanceof class_2483)) {
                return 0;
            }
            class_2483 abstractNbtList = (class_2483)current;
            int size = abstractNbtList.size();
            if (size == 0) {
                abstractNbtList.method_10533(0, source.get());
                return 1;
            }
            class_2520 nbtElement = source.get();
            Stream var10001 = abstractNbtList.stream();
            Objects.requireNonNull(nbtElement);
            int j = size - (int)var10001.filter(nbtElement::equals).count();
            if (j == 0) {
                return 0;
            }
            abstractNbtList.clear();
            if (!abstractNbtList.method_10533(0, nbtElement)) {
                return 0;
            }
            for (int k = 1; k < size; ++k) {
                abstractNbtList.method_10533(k, source.get());
            }
            return j;
        }

        @Override
        public int clear(class_2520 current) {
            class_2483 abstractNbtList;
            int size;
            if (current instanceof class_2483 && (size = (abstractNbtList = (class_2483)current).size()) > 0) {
                abstractNbtList.clear();
                return size;
            }
            return 0;
        }
    }

    static class IndexedListElementNode
    implements PathNode {
        private final int index;

        public IndexedListElementNode(int index) {
            this.index = index;
        }

        @Override
        public void get(class_2520 current, List<class_2520> results) {
            if (current instanceof class_2483) {
                int j;
                class_2483 abstractNbtList = (class_2483)current;
                int size = abstractNbtList.size();
                int n = j = this.index < 0 ? size + this.index : this.index;
                if (0 <= j && j < size) {
                    results.add((class_2520)abstractNbtList.get(j));
                }
            }
        }

        @Override
        public void getOrInit(class_2520 current, Supplier<class_2520> source, List<class_2520> results) {
            this.get(current, results);
        }

        @Override
        public class_2520 init() {
            return new class_2499();
        }

        @Override
        public int set(class_2520 current, Supplier<class_2520> source) {
            if (current instanceof class_2483) {
                int j;
                class_2483 abstractNbtList = (class_2483)current;
                int size = abstractNbtList.size();
                int n = j = this.index < 0 ? size + this.index : this.index;
                if (0 <= j && j < size) {
                    class_2520 nbtElement = (class_2520)abstractNbtList.get(j);
                    class_2520 nbtElement2 = source.get();
                    if (!nbtElement2.equals(nbtElement) && abstractNbtList.method_10535(j, nbtElement2)) {
                        return 1;
                    }
                }
            }
            return 0;
        }

        @Override
        public int clear(class_2520 current) {
            if (current instanceof class_2483) {
                int j;
                class_2483 abstractNbtList = (class_2483)current;
                int size = abstractNbtList.size();
                int n = j = this.index < 0 ? size + this.index : this.index;
                if (0 <= j && j < size) {
                    abstractNbtList.method_10536(j);
                    return 1;
                }
            }
            return 0;
        }
    }

    static class FilteredRootNode
    implements PathNode {
        private final Predicate<class_2520> matcher;

        public FilteredRootNode(class_2487 filter) {
            this.matcher = CNbtPathArgumentType.getPredicate(filter);
        }

        @Override
        public void get(class_2520 current, List<class_2520> results) {
            if (current instanceof class_2487 && this.matcher.test(current)) {
                results.add(current);
            }
        }

        @Override
        public void getOrInit(class_2520 current, Supplier<class_2520> source, List<class_2520> results) {
            this.get(current, results);
        }

        @Override
        public class_2520 init() {
            return new class_2487();
        }

        @Override
        public int set(class_2520 current, Supplier<class_2520> source) {
            return 0;
        }

        @Override
        public int clear(class_2520 current) {
            return 0;
        }
    }

    static class FilteredNamedNode
    implements PathNode {
        private final String name;
        private final class_2487 filter;
        private final Predicate<class_2520> predicate;

        public FilteredNamedNode(String name, class_2487 filter) {
            this.name = name;
            this.filter = filter;
            this.predicate = CNbtPathArgumentType.getPredicate(filter);
        }

        @Override
        public void get(class_2520 current, List<class_2520> results) {
            class_2520 nbtElement;
            if (current instanceof class_2487 && this.predicate.test(nbtElement = ((class_2487)current).method_10580(this.name))) {
                results.add(nbtElement);
            }
        }

        @Override
        public void getOrInit(class_2520 current, Supplier<class_2520> source, List<class_2520> results) {
            if (current instanceof class_2487) {
                class_2487 nbtCompound = (class_2487)current;
                class_2520 nbtElement = nbtCompound.method_10580(this.name);
                if (nbtElement == null) {
                    nbtElement = this.filter.method_10553();
                    nbtCompound.method_10566(this.name, nbtElement);
                    results.add(nbtElement);
                } else if (this.predicate.test(nbtElement)) {
                    results.add(nbtElement);
                }
            }
        }

        @Override
        public class_2520 init() {
            return new class_2487();
        }

        @Override
        public int set(class_2520 current, Supplier<class_2520> source) {
            class_2520 nbtElement2;
            class_2487 nbtCompound;
            class_2520 nbtElement;
            if (current instanceof class_2487 && this.predicate.test(nbtElement = (nbtCompound = (class_2487)current).method_10580(this.name)) && !(nbtElement2 = source.get()).equals(nbtElement)) {
                nbtCompound.method_10566(this.name, nbtElement2);
                return 1;
            }
            return 0;
        }

        @Override
        public int clear(class_2520 current) {
            class_2487 nbtCompound;
            class_2520 nbtElement;
            if (current instanceof class_2487 && this.predicate.test(nbtElement = (nbtCompound = (class_2487)current).method_10580(this.name))) {
                nbtCompound.method_10551(this.name);
                return 1;
            }
            return 0;
        }
    }

    private static class NamedNode
    implements PathNode {
        private final String name;

        public NamedNode(String name) {
            this.name = name;
        }

        @Override
        public void get(class_2520 current, List<class_2520> results) {
            class_2520 nbtElement;
            if (current instanceof class_2487 && (nbtElement = ((class_2487)current).method_10580(this.name)) != null) {
                results.add(nbtElement);
            }
        }

        @Override
        public void getOrInit(class_2520 current, Supplier<class_2520> source, List<class_2520> results) {
            if (current instanceof class_2487) {
                class_2520 nbtElement2;
                class_2487 nbtCompound = (class_2487)current;
                if (nbtCompound.method_10545(this.name)) {
                    nbtElement2 = nbtCompound.method_10580(this.name);
                } else {
                    nbtElement2 = source.get();
                    nbtCompound.method_10566(this.name, nbtElement2);
                }
                results.add(nbtElement2);
            }
        }

        @Override
        public class_2520 init() {
            return new class_2487();
        }

        @Override
        public int set(class_2520 current, Supplier<class_2520> source) {
            if (current instanceof class_2487) {
                class_2520 nbtElement2;
                class_2487 nbtCompound = (class_2487)current;
                class_2520 nbtElement = source.get();
                if (!nbtElement.equals(nbtElement2 = nbtCompound.method_10566(this.name, nbtElement))) {
                    return 1;
                }
            }
            return 0;
        }

        @Override
        public int clear(class_2520 current) {
            class_2487 nbtCompound;
            if (current instanceof class_2487 && (nbtCompound = (class_2487)current).method_10545(this.name)) {
                nbtCompound.method_10551(this.name);
                return 1;
            }
            return 0;
        }
    }
}

