/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.xpple.clientarguments.arguments.CEntitySelector;
import dev.xpple.clientarguments.arguments.CEntitySelectorReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class CMessageArgumentType
implements ArgumentType<MessageFormat> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Hello world!", "foo", "@e", "Hello @p :)");

    public static CMessageArgumentType message() {
        return new CMessageArgumentType();
    }

    public static class_2561 getCMessage(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        MessageFormat messageFormat = (MessageFormat)context.getArgument(name, MessageFormat.class);
        return messageFormat.format((FabricClientCommandSource)context.getSource());
    }

    public MessageFormat parse(StringReader stringReader) throws CommandSyntaxException {
        return MessageFormat.parse(stringReader, true);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public class_2561 toText(MessageFormat messageFormat) {
        return class_2561.method_43470((String)messageFormat.getContents());
    }

    public CompletableFuture<class_2561> decorate(FabricClientCommandSource source, MessageFormat messageFormat) throws CommandSyntaxException {
        return messageFormat.decorate(source);
    }

    public Class<MessageFormat> getFormatClass() {
        return MessageFormat.class;
    }

    public static class MessageFormat {
        final String contents;
        private final MessageSelector[] selectors;

        public MessageFormat(String contents, MessageSelector[] selectors) {
            this.contents = contents;
            this.selectors = selectors;
        }

        public String getContents() {
            return this.contents;
        }

        public MessageSelector[] getSelectors() {
            return this.selectors;
        }

        CompletableFuture<class_2561> decorate(FabricClientCommandSource source) throws CommandSyntaxException {
            class_2561 text = this.format(source);
            return CompletableFuture.completedFuture(text);
        }

        class_2561 format(FabricClientCommandSource source) throws CommandSyntaxException {
            return this.format(source, source.method_9259(2));
        }

        public class_2561 format(FabricClientCommandSource source, boolean canUseSelectors) throws CommandSyntaxException {
            if (this.selectors.length != 0 && canUseSelectors) {
                class_5250 mutableText = class_2561.method_43470((String)this.contents.substring(0, this.selectors[0].getStart()));
                int i = this.selectors[0].getStart();
                for (MessageSelector messageSelector : this.selectors) {
                    class_2561 text = messageSelector.format(source);
                    if (i < messageSelector.getStart()) {
                        mutableText.method_27693(this.contents.substring(i, messageSelector.getStart()));
                    }
                    if (text != null) {
                        mutableText.method_10852(text);
                    }
                    i = messageSelector.getEnd();
                }
                if (i < this.contents.length()) {
                    mutableText.method_27693(this.contents.substring(i));
                }
                return mutableText;
            }
            return class_2561.method_43470((String)this.contents);
        }

        public static MessageFormat parse(StringReader reader, boolean canUseSelectors) throws CommandSyntaxException {
            String string = reader.getString().substring(reader.getCursor(), reader.getTotalLength());
            if (!canUseSelectors) {
                reader.setCursor(reader.getTotalLength());
                return new MessageFormat(string, new MessageSelector[0]);
            }
            ArrayList list = Lists.newArrayList();
            int i = reader.getCursor();
            while (true) {
                CEntitySelector entitySelector;
                int j;
                block7: {
                    if (!reader.canRead()) {
                        return new MessageFormat(string, list.toArray(new MessageSelector[0]));
                    }
                    if (reader.peek() == '@') {
                        j = reader.getCursor();
                        try {
                            CEntitySelectorReader entitySelectorReader = new CEntitySelectorReader(reader);
                            entitySelector = entitySelectorReader.read();
                            break block7;
                        }
                        catch (CommandSyntaxException e) {
                            if (e.getType() != CEntitySelectorReader.MISSING_EXCEPTION && e.getType() != CEntitySelectorReader.UNKNOWN_SELECTOR_EXCEPTION) {
                                throw e;
                            }
                            reader.setCursor(j + 1);
                            continue;
                        }
                    }
                    reader.skip();
                    continue;
                }
                list.add(new MessageSelector(j - i, reader.getCursor() - i, entitySelector));
            }
        }
    }

    public static class MessageSelector {
        private final int start;
        private final int end;
        private final CEntitySelector selector;

        public MessageSelector(int start, int end, CEntitySelector selector) {
            this.start = start;
            this.end = end;
            this.selector = selector;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public CEntitySelector getSelector() {
            return this.selector;
        }

        @Nullable
        public class_2561 format(FabricClientCommandSource source) throws CommandSyntaxException {
            return CEntitySelector.getNames(this.selector.getEntities(source));
        }
    }
}

