/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class CItemSlotArgumentType
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("container.5", "12", "weapon");
    private static final DynamicCommandExceptionType UNKNOWN_SLOT_EXCEPTION = new DynamicCommandExceptionType(name -> class_2561.method_43469((String)"slot.unknown", (Object[])new Object[]{name}));
    private static final Map<String, Integer> SLOT_NAMES_TO_SLOT_COMMAND_ID = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        int n;
        for (n = 0; n < 54; ++n) {
            map.put("container." + n, n);
        }
        for (n = 0; n < 9; ++n) {
            map.put("hotbar." + n, n);
        }
        for (n = 0; n < 27; ++n) {
            map.put("inventory." + n, 9 + n);
        }
        for (n = 0; n < 27; ++n) {
            map.put("enderchest." + n, 200 + n);
        }
        for (n = 0; n < 8; ++n) {
            map.put("villager." + n, 300 + n);
        }
        for (n = 0; n < 15; ++n) {
            map.put("horse." + n, 500 + n);
        }
        map.put("weapon", class_1304.field_6173.method_32320(98));
        map.put("weapon.mainhand", class_1304.field_6173.method_32320(98));
        map.put("weapon.offhand", class_1304.field_6171.method_32320(98));
        map.put("armor.head", class_1304.field_6169.method_32320(100));
        map.put("armor.chest", class_1304.field_6174.method_32320(100));
        map.put("armor.legs", class_1304.field_6172.method_32320(100));
        map.put("armor.feet", class_1304.field_6166.method_32320(100));
        map.put("horse.saddle", 400);
        map.put("horse.armor", 401);
        map.put("horse.chest", 499);
    });

    public static CItemSlotArgumentType itemSlot() {
        return new CItemSlotArgumentType();
    }

    public static Integer getCItemSlot(CommandContext<FabricClientCommandSource> context, String name) {
        return (Integer)context.getArgument(name, Integer.class);
    }

    public Integer parse(StringReader stringReader) throws CommandSyntaxException {
        String string = stringReader.readUnquotedString();
        if (SLOT_NAMES_TO_SLOT_COMMAND_ID.containsKey(string)) {
            return SLOT_NAMES_TO_SLOT_COMMAND_ID.get(string);
        }
        throw UNKNOWN_SLOT_EXCEPTION.create((Object)string);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(SLOT_NAMES_TO_SLOT_COMMAND_ID.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

