/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.clientarguments.arguments.CEntityArgumentType;
import dev.xpple.clientarguments.arguments.CEntitySelector;
import dev.xpple.clientarguments.arguments.CEntitySelectorReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_742;

public class CGameProfileArgumentType
implements ArgumentType<GameProfileArgument> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "dd12be42-52a9-4a91-a8a1-11c01849e498", "@e");
    public static final SimpleCommandExceptionType UNKNOWN_PLAYER_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.player.unknown"));

    public static CGameProfileArgumentType gameProfile() {
        return new CGameProfileArgumentType();
    }

    public static Collection<GameProfile> getCProfileArgument(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        return ((GameProfileArgument)context.getArgument(name, GameProfileArgument.class)).getNames((FabricClientCommandSource)context.getSource());
    }

    public GameProfileArgument parse(StringReader stringReader) throws CommandSyntaxException {
        if (stringReader.canRead() && stringReader.peek() == '@') {
            CEntitySelectorReader entitySelectorReader = new CEntitySelectorReader(stringReader);
            CEntitySelector entitySelector = entitySelectorReader.read();
            if (entitySelector.includesNonPlayers()) {
                throw CEntityArgumentType.PLAYER_SELECTOR_HAS_ENTITIES_EXCEPTION.create();
            }
            return new SelectorBacked(entitySelector);
        }
        int cursor = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        String string = stringReader.getString().substring(cursor, stringReader.getCursor());
        return source -> Collections.singleton(class_310.method_1551().method_1562().method_2880().stream().map(class_640::method_2966).filter(profile -> profile.getName().equals(string)).findFirst().orElseThrow(() -> ((SimpleCommandExceptionType)UNKNOWN_PLAYER_EXCEPTION).create()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof class_2172) {
            StringReader stringReader = new StringReader(builder.getInput());
            stringReader.setCursor(builder.getStart());
            CEntitySelectorReader entitySelectorReader = new CEntitySelectorReader(stringReader);
            try {
                entitySelectorReader.read();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return entitySelectorReader.listSuggestions(builder, (SuggestionsBuilder builderx) -> class_2172.method_9265((Iterable)((class_2172)context.getSource()).method_9262(), (SuggestionsBuilder)builderx));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @FunctionalInterface
    public static interface GameProfileArgument {
        public Collection<GameProfile> getNames(FabricClientCommandSource var1) throws CommandSyntaxException;
    }

    public static class SelectorBacked
    implements GameProfileArgument {
        private final CEntitySelector selector;

        public SelectorBacked(CEntitySelector selector) {
            this.selector = selector;
        }

        @Override
        public Collection<GameProfile> getNames(FabricClientCommandSource clientCommandSource) throws CommandSyntaxException {
            List<class_742> list = this.selector.getPlayers(clientCommandSource);
            if (list.isEmpty()) {
                throw CEntityArgumentType.PLAYER_NOT_FOUND_EXCEPTION.create();
            }
            ArrayList<GameProfile> profiles = new ArrayList<GameProfile>();
            for (class_742 abstractPlayer : list) {
                profiles.add(abstractPlayer.method_7334());
            }
            return profiles;
        }
    }
}

