/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.google.common.primitives.Doubles;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.clientarguments.arguments.CEntitySelector;
import dev.xpple.clientarguments.arguments.CEntitySelectorOptions;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2096;
import net.minecraft.class_2152;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class CEntitySelectorReader {
    public static final SimpleCommandExceptionType INVALID_ENTITY_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.entity.invalid"));
    public static final DynamicCommandExceptionType UNKNOWN_SELECTOR_EXCEPTION = new DynamicCommandExceptionType(selectorType -> class_2561.method_43469((String)"argument.entity.selector.unknown", (Object[])new Object[]{selectorType}));
    public static final SimpleCommandExceptionType NOT_ALLOWED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.entity.selector.not_allowed"));
    public static final SimpleCommandExceptionType MISSING_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.entity.selector.missing"));
    public static final SimpleCommandExceptionType UNTERMINATED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.entity.options.unterminated"));
    public static final DynamicCommandExceptionType VALUELESS_EXCEPTION = new DynamicCommandExceptionType(option -> class_2561.method_43469((String)"argument.entity.options.valueless", (Object[])new Object[]{option}));
    public static final BiConsumer<class_243, List<? extends class_1297>> ARBITRARY = (pos, entities) -> {};
    public static final BiConsumer<class_243, List<? extends class_1297>> NEAREST = (pos, entities) -> entities.sort((entity1, entity2) -> Doubles.compare((double)entity1.method_5707(pos), (double)entity2.method_5707(pos)));
    public static final BiConsumer<class_243, List<? extends class_1297>> FURTHEST = (pos, entities) -> entities.sort((entity1, entity2) -> Doubles.compare((double)entity2.method_5707(pos), (double)entity1.method_5707(pos)));
    public static final BiConsumer<class_243, List<? extends class_1297>> RANDOM = (pos, entities) -> Collections.shuffle(entities);
    public static final BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> DEFAULT_SUGGESTION_PROVIDER = (builder, consumer) -> builder.buildFuture();
    private final StringReader reader;
    private final boolean atAllowed;
    private int limit;
    private boolean includesNonPlayers;
    private class_2096.class_2099 distance = class_2096.class_2099.field_9705;
    private class_2096.class_2100 levelRange = class_2096.class_2100.field_9708;
    @Nullable
    private Double x;
    @Nullable
    private Double y;
    @Nullable
    private Double z;
    @Nullable
    private Double dx;
    @Nullable
    private Double dy;
    @Nullable
    private Double dz;
    private class_2152 pitchRange = class_2152.field_9780;
    private class_2152 yawRange = class_2152.field_9780;
    private Predicate<class_1297> predicate = entity -> true;
    private BiConsumer<class_243, List<? extends class_1297>> sorter = ARBITRARY;
    private boolean senderOnly;
    @Nullable
    private String playerName;
    private int startCursor;
    @Nullable
    private UUID uuid;
    private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> suggestionProvider = DEFAULT_SUGGESTION_PROVIDER;
    private boolean selectsName;
    private boolean excludesName;
    private boolean hasLimit;
    private boolean hasSorter;
    private boolean selectsGameMode;
    private boolean excludesGameMode;
    private boolean selectsTeam;
    private boolean excludesTeam;
    @Nullable
    private class_1299<?> entityType;
    private boolean excludesEntityType;
    private boolean selectsScores;
    private boolean selectsAdvancements;
    private boolean usesAt;

    public CEntitySelectorReader(StringReader reader) {
        this(reader, true);
    }

    public CEntitySelectorReader(StringReader reader, boolean atAllowed) {
        this.reader = reader;
        this.atAllowed = atAllowed;
    }

    public CEntitySelector build() {
        class_238 box;
        if (this.dx != null || this.dy != null || this.dz != null) {
            box = this.createBox(this.dx == null ? 0.0 : this.dx, this.dy == null ? 0.0 : this.dy, this.dz == null ? 0.0 : this.dz);
        } else if (this.distance.method_9042() != null) {
            double d = (Double)this.distance.method_9042();
            box = new class_238(-d, -d, -d, d + 1.0, d + 1.0, d + 1.0);
        } else {
            box = null;
        }
        Function<class_243, class_243> d = this.x == null && this.y == null && this.z == null ? pos -> pos : pos -> new class_243(this.x == null ? pos.field_1352 : this.x, this.y == null ? pos.field_1351 : this.y, this.z == null ? pos.field_1350 : this.z);
        return new CEntitySelector(this.limit, this.includesNonPlayers, this.predicate, this.distance, d, box, this.sorter, this.senderOnly, this.playerName, this.uuid, this.entityType, this.usesAt);
    }

    private class_238 createBox(double x, double y, double z) {
        boolean bl = x < 0.0;
        boolean bl2 = y < 0.0;
        boolean bl3 = z < 0.0;
        double d = bl ? x : 0.0;
        double e = bl2 ? y : 0.0;
        double f = bl3 ? z : 0.0;
        double g = (bl ? 0.0 : x) + 1.0;
        double h = (bl2 ? 0.0 : y) + 1.0;
        double i = (bl3 ? 0.0 : z) + 1.0;
        return new class_238(d, e, f, g, h, i);
    }

    private void buildPredicate() {
        if (this.pitchRange != class_2152.field_9780) {
            this.predicate = this.predicate.and(this.rotationPredicate(this.pitchRange, class_1297::method_36455));
        }
        if (this.yawRange != class_2152.field_9780) {
            this.predicate = this.predicate.and(this.rotationPredicate(this.yawRange, class_1297::method_36454));
        }
        if (!this.levelRange.method_9041()) {
            this.predicate = this.predicate.and(entity -> {
                if (!(entity instanceof class_3222)) {
                    return false;
                }
                return this.levelRange.method_9054(((class_3222)entity).field_7520);
            });
        }
    }

    private Predicate<class_1297> rotationPredicate(class_2152 angleRange, ToDoubleFunction<class_1297> entityToAngle) {
        double d = class_3532.method_15393((float)(angleRange.method_9175() == null ? 0.0f : angleRange.method_9175().floatValue()));
        double e = class_3532.method_15393((float)(angleRange.method_9177() == null ? 359.0f : angleRange.method_9177().floatValue()));
        return entity -> {
            double f = class_3532.method_15338((double)entityToAngle.applyAsDouble((class_1297)entity));
            if (d > e) {
                return f >= d || f <= e;
            }
            return f >= d && f <= e;
        };
    }

    protected void readAtVariable() throws CommandSyntaxException {
        this.usesAt = true;
        this.suggestionProvider = this::suggestSelectorRest;
        if (!this.reader.canRead()) {
            throw MISSING_EXCEPTION.createWithContext((ImmutableStringReader)this.reader);
        }
        int i = this.reader.getCursor();
        char c = this.reader.read();
        if (c == 'p') {
            this.limit = 1;
            this.includesNonPlayers = false;
            this.sorter = NEAREST;
            this.setEntityType(class_1299.field_6097);
        } else if (c == 'a') {
            this.limit = Integer.MAX_VALUE;
            this.includesNonPlayers = false;
            this.sorter = ARBITRARY;
            this.setEntityType(class_1299.field_6097);
        } else if (c == 'r') {
            this.limit = 1;
            this.includesNonPlayers = false;
            this.sorter = RANDOM;
            this.setEntityType(class_1299.field_6097);
        } else if (c == 's') {
            this.limit = 1;
            this.includesNonPlayers = true;
            this.senderOnly = true;
        } else if (c == 'e') {
            this.limit = Integer.MAX_VALUE;
            this.includesNonPlayers = true;
            this.sorter = ARBITRARY;
            this.predicate = class_1297::method_5805;
        } else {
            this.reader.setCursor(i);
            throw UNKNOWN_SELECTOR_EXCEPTION.createWithContext((ImmutableStringReader)this.reader, (Object)("@" + c));
        }
        this.suggestionProvider = this::suggestOpen;
        if (this.reader.canRead() && this.reader.peek() == '[') {
            this.reader.skip();
            this.suggestionProvider = this::suggestOptionOrEnd;
            this.readArguments();
        }
    }

    protected void readRegular() throws CommandSyntaxException {
        if (this.reader.canRead()) {
            this.suggestionProvider = this::suggestNormal;
        }
        int i = this.reader.getCursor();
        String string = this.reader.readString();
        try {
            this.uuid = UUID.fromString(string);
            this.includesNonPlayers = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (string.isEmpty() || string.length() > 16) {
                this.reader.setCursor(i);
                throw INVALID_ENTITY_EXCEPTION.createWithContext((ImmutableStringReader)this.reader);
            }
            this.includesNonPlayers = false;
            this.playerName = string;
        }
        this.limit = 1;
    }

    protected void readArguments() throws CommandSyntaxException {
        this.suggestionProvider = this::suggestOption;
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != ']') {
            this.reader.skipWhitespace();
            int i = this.reader.getCursor();
            String string = this.reader.readString();
            CEntitySelectorOptions.SelectorHandler selectorHandler = CEntitySelectorOptions.getHandler(this, string, i);
            this.reader.skipWhitespace();
            if (!this.reader.canRead() || this.reader.peek() != '=') {
                this.reader.setCursor(i);
                throw VALUELESS_EXCEPTION.createWithContext((ImmutableStringReader)this.reader, (Object)string);
            }
            this.reader.skip();
            this.reader.skipWhitespace();
            this.suggestionProvider = DEFAULT_SUGGESTION_PROVIDER;
            selectorHandler.handle(this);
            this.reader.skipWhitespace();
            this.suggestionProvider = this::suggestEndNext;
            if (!this.reader.canRead()) continue;
            if (this.reader.peek() == ',') {
                this.reader.skip();
                this.suggestionProvider = this::suggestOption;
                continue;
            }
            if (this.reader.peek() == ']') break;
            throw UNTERMINATED_EXCEPTION.createWithContext((ImmutableStringReader)this.reader);
        }
        if (!this.reader.canRead()) {
            throw UNTERMINATED_EXCEPTION.createWithContext((ImmutableStringReader)this.reader);
        }
        this.reader.skip();
        this.suggestionProvider = DEFAULT_SUGGESTION_PROVIDER;
    }

    public boolean readNegationCharacter() {
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == '!') {
            this.reader.skip();
            this.reader.skipWhitespace();
            return true;
        }
        return false;
    }

    public boolean readTagCharacter() {
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == '#') {
            this.reader.skip();
            this.reader.skipWhitespace();
            return true;
        }
        return false;
    }

    public StringReader getReader() {
        return this.reader;
    }

    public void setPredicate(Predicate<class_1297> predicate) {
        this.predicate = this.predicate.and(predicate);
    }

    public class_2096.class_2099 getDistance() {
        return this.distance;
    }

    public void setDistance(class_2096.class_2099 distance) {
        this.distance = distance;
    }

    public class_2096.class_2100 getLevelRange() {
        return this.levelRange;
    }

    public void setLevelRange(class_2096.class_2100 levelRange) {
        this.levelRange = levelRange;
    }

    public class_2152 getPitchRange() {
        return this.pitchRange;
    }

    public void setPitchRange(class_2152 pitchRange) {
        this.pitchRange = pitchRange;
    }

    public class_2152 getYawRange() {
        return this.yawRange;
    }

    public void setYawRange(class_2152 yawRange) {
        this.yawRange = yawRange;
    }

    @Nullable
    public Double getX() {
        return this.x;
    }

    @Nullable
    public Double getY() {
        return this.y;
    }

    @Nullable
    public Double getZ() {
        return this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setDx(double dx) {
        this.dx = dx;
    }

    public void setDy(double dy) {
        this.dy = dy;
    }

    public void setDz(double dz) {
        this.dz = dz;
    }

    @Nullable
    public Double getDx() {
        return this.dx;
    }

    @Nullable
    public Double getDy() {
        return this.dy;
    }

    @Nullable
    public Double getDz() {
        return this.dz;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setIncludesNonPlayers(boolean includesNonPlayers) {
        this.includesNonPlayers = includesNonPlayers;
    }

    public BiConsumer<class_243, List<? extends class_1297>> getSorter() {
        return this.sorter;
    }

    public void setSorter(BiConsumer<class_243, List<? extends class_1297>> sorter) {
        this.sorter = sorter;
    }

    public CEntitySelector read() throws CommandSyntaxException {
        this.startCursor = this.reader.getCursor();
        this.suggestionProvider = this::suggestSelector;
        if (this.reader.canRead() && this.reader.peek() == '@') {
            if (!this.atAllowed) {
                throw NOT_ALLOWED_EXCEPTION.createWithContext((ImmutableStringReader)this.reader);
            }
            this.reader.skip();
            this.readAtVariable();
        } else {
            this.readRegular();
        }
        this.buildPredicate();
        return this.build();
    }

    private static void suggestSelector(SuggestionsBuilder builder) {
        builder.suggest("@p", (Message)class_2561.method_43471((String)"argument.entity.selector.nearestPlayer"));
        builder.suggest("@a", (Message)class_2561.method_43471((String)"argument.entity.selector.allPlayers"));
        builder.suggest("@r", (Message)class_2561.method_43471((String)"argument.entity.selector.randomPlayer"));
        builder.suggest("@s", (Message)class_2561.method_43471((String)"argument.entity.selector.self"));
        builder.suggest("@e", (Message)class_2561.method_43471((String)"argument.entity.selector.allEntities"));
    }

    private CompletableFuture<Suggestions> suggestSelector(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        consumer.accept(builder);
        if (this.atAllowed) {
            CEntitySelectorReader.suggestSelector(builder);
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestNormal(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        SuggestionsBuilder suggestionsBuilder = builder.createOffset(this.startCursor);
        consumer.accept(suggestionsBuilder);
        return builder.add(suggestionsBuilder).buildFuture();
    }

    private CompletableFuture<Suggestions> suggestSelectorRest(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        SuggestionsBuilder suggestionsBuilder = builder.createOffset(builder.getStart() - 1);
        CEntitySelectorReader.suggestSelector(suggestionsBuilder);
        builder.add(suggestionsBuilder);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpen(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf('['));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOptionOrEnd(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf(']'));
        CEntitySelectorOptions.suggestOptions(this, builder);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOption(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        CEntitySelectorOptions.suggestOptions(this, builder);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestEndNext(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf(','));
        builder.suggest(String.valueOf(']'));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestDefinerNext(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf('='));
        return builder.buildFuture();
    }

    public boolean isSenderOnly() {
        return this.senderOnly;
    }

    public void setSuggestionProvider(BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> suggestionProvider) {
        this.suggestionProvider = suggestionProvider;
    }

    public CompletableFuture<Suggestions> listSuggestions(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        return this.suggestionProvider.apply(builder.createOffset(this.reader.getCursor()), consumer);
    }

    public boolean selectsName() {
        return this.selectsName;
    }

    public void setSelectsName(boolean selectsName) {
        this.selectsName = selectsName;
    }

    public boolean excludesName() {
        return this.excludesName;
    }

    public void setExcludesName(boolean excludesName) {
        this.excludesName = excludesName;
    }

    public boolean hasLimit() {
        return this.hasLimit;
    }

    public void setHasLimit(boolean hasLimit) {
        this.hasLimit = hasLimit;
    }

    public boolean hasSorter() {
        return this.hasSorter;
    }

    public void setHasSorter(boolean hasSorter) {
        this.hasSorter = hasSorter;
    }

    public boolean selectsGameMode() {
        return this.selectsGameMode;
    }

    public void setSelectsGameMode(boolean selectsGameMode) {
        this.selectsGameMode = selectsGameMode;
    }

    public boolean excludesGameMode() {
        return this.excludesGameMode;
    }

    public void setExcludesGameMode(boolean excludesGameMode) {
        this.excludesGameMode = excludesGameMode;
    }

    public boolean selectsTeam() {
        return this.selectsTeam;
    }

    public void setSelectsTeam(boolean selectsTeam) {
        this.selectsTeam = selectsTeam;
    }

    public boolean excludesTeam() {
        return this.excludesTeam;
    }

    public void setExcludesTeam(boolean excludesTeam) {
        this.excludesTeam = excludesTeam;
    }

    public void setEntityType(@Nullable class_1299<?> entityType) {
        this.entityType = entityType;
    }

    public void setExcludesEntityType() {
        this.excludesEntityType = true;
    }

    public boolean selectsEntityType() {
        return this.entityType != null;
    }

    public boolean excludesEntityType() {
        return this.excludesEntityType;
    }

    public boolean selectsScores() {
        return this.selectsScores;
    }

    public void setSelectsScores(boolean selectsScores) {
        this.selectsScores = selectsScores;
    }

    public boolean selectsAdvancements() {
        return this.selectsAdvancements;
    }

    public void setSelectsAdvancements(boolean selectsAdvancements) {
        this.selectsAdvancements = selectsAdvancements;
    }
}

