/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.clientarguments.arguments.CEntitySelectorReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_167;
import net.minecraft.class_178;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2096;
import net.minecraft.class_2152;
import net.minecraft.class_2172;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_742;
import net.minecraft.class_745;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CEntitySelectorOptions {
    private static final Map<String, SelectorOption> OPTIONS = new HashMap<String, SelectorOption>();
    public static final DynamicCommandExceptionType UNKNOWN_OPTION_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"argument.entity.options.unknown", (Object[])new Object[]{arg}));
    public static final DynamicCommandExceptionType INAPPLICABLE_OPTION_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"argument.entity.options.inapplicable", (Object[])new Object[]{arg}));
    public static final SimpleCommandExceptionType NEGATIVE_DISTANCE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.entity.options.distance.negative"));
    public static final SimpleCommandExceptionType NEGATIVE_LEVEL_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.entity.options.level.negative"));
    public static final SimpleCommandExceptionType TOO_SMALL_LEVEL_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.entity.options.limit.toosmall"));
    public static final DynamicCommandExceptionType IRREVERSIBLE_SORT_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"argument.entity.options.sort.irreversible", (Object[])new Object[]{arg}));
    public static final DynamicCommandExceptionType INVALID_MODE_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"argument.entity.options.mode.invalid", (Object[])new Object[]{arg}));
    public static final DynamicCommandExceptionType INVALID_TYPE_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_43469((String)"argument.entity.options.type.invalid", (Object[])new Object[]{arg}));

    private static void putOption(String id, SelectorHandler handler, Predicate<CEntitySelectorReader> condition, class_2561 description) {
        OPTIONS.put(id, new SelectorOption(handler, condition, description));
    }

    public static void register() {
        if (!OPTIONS.isEmpty()) {
            return;
        }
        CEntitySelectorOptions.putOption("name", reader2 -> {
            int i = reader2.getReader().getCursor();
            boolean bl = reader2.readNegationCharacter();
            String string = reader2.getReader().readString();
            if (reader2.excludesName() && !bl) {
                reader2.getReader().setCursor(i);
                throw INAPPLICABLE_OPTION_EXCEPTION.createWithContext((ImmutableStringReader)reader2.getReader(), (Object)"name");
            }
            if (bl) {
                reader2.setExcludesName(true);
            } else {
                reader2.setSelectsName(true);
            }
            reader2.setPredicate(reader -> reader.method_5477().getString().equals(string) != bl);
        }, reader -> !reader.selectsName(), (class_2561)class_2561.method_43471((String)"argument.entity.options.name.description"));
        CEntitySelectorOptions.putOption("distance", reader -> {
            int i = reader.getReader().getCursor();
            class_2096.class_2099 floatRange = class_2096.class_2099.method_9049((StringReader)reader.getReader());
            if (floatRange.method_9038() != null && (Double)floatRange.method_9038() < 0.0 || floatRange.method_9042() != null && (Double)floatRange.method_9042() < 0.0) {
                reader.getReader().setCursor(i);
                throw NEGATIVE_DISTANCE_EXCEPTION.createWithContext((ImmutableStringReader)reader.getReader());
            }
            reader.setDistance(floatRange);
        }, reader -> reader.getDistance().method_9041(), (class_2561)class_2561.method_43471((String)"argument.entity.options.distance.description"));
        CEntitySelectorOptions.putOption("level", reader -> {
            int i = reader.getReader().getCursor();
            class_2096.class_2100 intRange = class_2096.class_2100.method_9060((StringReader)reader.getReader());
            if (intRange.method_9038() != null && (Integer)intRange.method_9038() < 0 || intRange.method_9042() != null && (Integer)intRange.method_9042() < 0) {
                reader.getReader().setCursor(i);
                throw NEGATIVE_LEVEL_EXCEPTION.createWithContext((ImmutableStringReader)reader.getReader());
            }
            reader.setLevelRange(intRange);
            reader.setIncludesNonPlayers(false);
        }, reader -> reader.getLevelRange().method_9041(), (class_2561)class_2561.method_43471((String)"argument.entity.options.level.description"));
        CEntitySelectorOptions.putOption("x", reader -> reader.setX(reader.getReader().readDouble()), reader -> reader.getX() == null, (class_2561)class_2561.method_43471((String)"argument.entity.options.x.description"));
        CEntitySelectorOptions.putOption("y", reader -> reader.setY(reader.getReader().readDouble()), reader -> reader.getY() == null, (class_2561)class_2561.method_43471((String)"argument.entity.options.y.description"));
        CEntitySelectorOptions.putOption("z", reader -> reader.setZ(reader.getReader().readDouble()), reader -> reader.getZ() == null, (class_2561)class_2561.method_43471((String)"argument.entity.options.z.description"));
        CEntitySelectorOptions.putOption("dx", reader -> reader.setDx(reader.getReader().readDouble()), reader -> reader.getDx() == null, (class_2561)class_2561.method_43471((String)"argument.entity.options.dx.description"));
        CEntitySelectorOptions.putOption("dy", reader -> reader.setDy(reader.getReader().readDouble()), reader -> reader.getDy() == null, (class_2561)class_2561.method_43471((String)"argument.entity.options.dy.description"));
        CEntitySelectorOptions.putOption("dz", reader -> reader.setDz(reader.getReader().readDouble()), reader -> reader.getDz() == null, (class_2561)class_2561.method_43471((String)"argument.entity.options.dz.description"));
        CEntitySelectorOptions.putOption("x_rotation", reader -> reader.setPitchRange(class_2152.method_9172((StringReader)reader.getReader(), (boolean)true, class_3532::method_15393)), reader -> reader.getPitchRange() == class_2152.field_9780, (class_2561)class_2561.method_43471((String)"argument.entity.options.x_rotation.description"));
        CEntitySelectorOptions.putOption("y_rotation", reader -> reader.setYawRange(class_2152.method_9172((StringReader)reader.getReader(), (boolean)true, class_3532::method_15393)), reader -> reader.getYawRange() == class_2152.field_9780, (class_2561)class_2561.method_43471((String)"argument.entity.options.y_rotation.description"));
        CEntitySelectorOptions.putOption("limit", reader -> {
            int i = reader.getReader().getCursor();
            int j = reader.getReader().readInt();
            if (j < 1) {
                reader.getReader().setCursor(i);
                throw TOO_SMALL_LEVEL_EXCEPTION.createWithContext((ImmutableStringReader)reader.getReader());
            }
            reader.setLimit(j);
            reader.setHasLimit(true);
        }, reader -> !reader.isSenderOnly() && !reader.hasLimit(), (class_2561)class_2561.method_43471((String)"argument.entity.options.limit.description"));
        CEntitySelectorOptions.putOption("sort", reader -> {
            int i = reader.getReader().getCursor();
            String string = reader.getReader().readUnquotedString();
            reader.setSuggestionProvider((builder, consumer) -> class_2172.method_9265(Arrays.asList("nearest", "furthest", "random", "arbitrary"), (SuggestionsBuilder)builder));
            reader.setSorter(switch (string) {
                case "nearest" -> class_2303.field_10869;
                case "furthest" -> class_2303.field_10882;
                case "random" -> class_2303.field_10850;
                case "arbitrary" -> class_2300.field_41524;
                default -> {
                    reader.getReader().setCursor(i);
                    throw IRREVERSIBLE_SORT_EXCEPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)string);
                }
            });
            reader.setHasSorter(true);
        }, reader -> !reader.isSenderOnly() && !reader.hasSorter(), (class_2561)class_2561.method_43471((String)"argument.entity.options.sort.description"));
        CEntitySelectorOptions.putOption("gamemode", reader -> {
            reader.setSuggestionProvider((builder, consumer) -> {
                String string = builder.getRemaining().toLowerCase(Locale.ROOT);
                boolean bl = !reader.excludesGameMode();
                boolean bl2 = true;
                if (!string.isEmpty()) {
                    if (string.charAt(0) == '!') {
                        bl = false;
                        string = string.substring(1);
                    } else {
                        bl2 = false;
                    }
                }
                for (class_1934 gameMode : class_1934.values()) {
                    if (!gameMode.method_8381().toLowerCase(Locale.ROOT).startsWith(string)) continue;
                    if (bl2) {
                        builder.suggest("!" + gameMode.method_8381());
                    }
                    if (!bl) continue;
                    builder.suggest(gameMode.method_8381());
                }
                return builder.buildFuture();
            });
            int i = reader.getReader().getCursor();
            boolean bl = reader.readNegationCharacter();
            if (reader.excludesGameMode() && !bl) {
                reader.getReader().setCursor(i);
                throw INAPPLICABLE_OPTION_EXCEPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)"gamemode");
            }
            String string = reader.getReader().readUnquotedString();
            class_1934 gameMode = class_1934.method_8378((String)string, null);
            if (gameMode == null) {
                reader.getReader().setCursor(i);
                throw INVALID_MODE_EXCEPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)string);
            }
            reader.setIncludesNonPlayers(false);
            reader.setPredicate(entity -> {
                if (!(entity instanceof class_742)) {
                    return false;
                }
                class_742 player = (class_742)entity;
                class_1934 gameMode2 = class_310.method_1551().field_1724.field_3944.method_2871(player.method_5667()).method_2958();
                return bl == (gameMode2 != gameMode);
            });
            if (bl) {
                reader.setExcludesGameMode(true);
            } else {
                reader.setSelectsGameMode(true);
            }
        }, reader -> !reader.selectsGameMode(), (class_2561)class_2561.method_43471((String)"argument.entity.options.gamemode.description"));
        CEntitySelectorOptions.putOption("team", reader -> {
            boolean bl = reader.readNegationCharacter();
            String string = reader.getReader().readUnquotedString();
            reader.setPredicate(entity -> {
                if (!(entity instanceof class_1309)) {
                    return false;
                }
                class_270 abstractTeam = entity.method_5781();
                String string2 = abstractTeam == null ? "" : abstractTeam.method_1197();
                return string2.equals(string) != bl;
            });
            if (bl) {
                reader.setExcludesTeam(true);
            } else {
                reader.setSelectsTeam(true);
            }
        }, reader -> !reader.selectsTeam(), (class_2561)class_2561.method_43471((String)"argument.entity.options.team.description"));
        CEntitySelectorOptions.putOption("type", reader -> {
            reader.setSuggestionProvider((builder, consumer) -> {
                class_2172.method_9258((Iterable)class_7923.field_41177.method_10235(), (SuggestionsBuilder)builder, (String)String.valueOf('!'));
                class_2172.method_40182(class_7923.field_41177.method_40273().map(class_6862::comp_327), (SuggestionsBuilder)builder, (String)"!#");
                if (!reader.excludesEntityType()) {
                    class_2172.method_9270((Iterable)class_7923.field_41177.method_10235(), (SuggestionsBuilder)builder);
                    class_2172.method_40182(class_7923.field_41177.method_40273().map(class_6862::comp_327), (SuggestionsBuilder)builder, (String)String.valueOf('#'));
                }
                return builder.buildFuture();
            });
            int i = reader.getReader().getCursor();
            boolean bl = reader.readNegationCharacter();
            if (reader.excludesEntityType() && !bl) {
                reader.getReader().setCursor(i);
                throw INAPPLICABLE_OPTION_EXCEPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)"type");
            }
            if (bl) {
                reader.setExcludesEntityType();
            }
            if (reader.readTagCharacter()) {
                class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_12835((StringReader)reader.getReader()));
                reader.setPredicate(entity -> entity.method_5864().method_20210(tagKey) != bl);
            } else {
                class_2960 tagKey = class_2960.method_12835((StringReader)reader.getReader());
                class_1299 entityType = (class_1299)class_7923.field_41177.method_17966(tagKey).orElseThrow(() -> {
                    reader.getReader().setCursor(i);
                    return INVALID_TYPE_EXCEPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)tagKey.toString());
                });
                if (Objects.equals(class_1299.field_6097, entityType) && !bl) {
                    reader.setIncludesNonPlayers(false);
                }
                reader.setPredicate(entity -> Objects.equals(entityType, entity.method_5864()) != bl);
                if (!bl) {
                    reader.setEntityType(entityType);
                }
            }
        }, reader -> !reader.selectsEntityType(), (class_2561)class_2561.method_43471((String)"argument.entity.options.type.description"));
        CEntitySelectorOptions.putOption("tag", reader -> {
            boolean bl = reader.readNegationCharacter();
            String string = reader.getReader().readUnquotedString();
            reader.setPredicate(entity -> {
                if ("".equals(string)) {
                    return entity.method_5752().isEmpty() != bl;
                }
                return entity.method_5752().contains(string) != bl;
            });
        }, reader -> true, (class_2561)class_2561.method_43471((String)"argument.entity.options.tag.description"));
        CEntitySelectorOptions.putOption("nbt", reader -> {
            boolean bl = reader.readNegationCharacter();
            class_2487 nbtCompound = new class_2522(reader.getReader()).method_10727();
            reader.setPredicate(entity -> {
                class_1799 itemStack;
                class_2487 nbtCompound2 = entity.method_5647(new class_2487());
                if (entity instanceof class_745 && !(itemStack = ((class_745)entity).method_31548().method_7391()).method_7960()) {
                    nbtCompound2.method_10566("SelectedItem", (class_2520)itemStack.method_7953(new class_2487()));
                }
                return class_2512.method_10687((class_2520)nbtCompound, (class_2520)nbtCompound2, (boolean)true) != bl;
            });
        }, reader -> true, (class_2561)class_2561.method_43471((String)"argument.entity.options.nbt.description"));
        CEntitySelectorOptions.putOption("scores", reader -> {
            StringReader stringReader = reader.getReader();
            HashMap map = Maps.newHashMap();
            stringReader.expect('{');
            stringReader.skipWhitespace();
            while (stringReader.canRead() && stringReader.peek() != '}') {
                stringReader.skipWhitespace();
                String string = stringReader.readUnquotedString();
                stringReader.skipWhitespace();
                stringReader.expect('=');
                stringReader.skipWhitespace();
                class_2096.class_2100 intRange = class_2096.class_2100.method_9060((StringReader)stringReader);
                map.put(string, intRange);
                stringReader.skipWhitespace();
                if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                stringReader.skip();
            }
            stringReader.expect('}');
            if (!map.isEmpty()) {
                reader.setPredicate(entity -> {
                    class_269 scoreboard = entity.method_37908().method_8428();
                    String string = entity.method_5820();
                    for (Map.Entry entry : map.entrySet()) {
                        class_266 scoreboardObjective = scoreboard.method_1170((String)entry.getKey());
                        if (scoreboardObjective == null) {
                            return false;
                        }
                        if (!scoreboard.method_1183(string, scoreboardObjective)) {
                            return false;
                        }
                        class_267 scoreboardPlayerScore = scoreboard.method_1180(string, scoreboardObjective);
                        int i = scoreboardPlayerScore.method_1126();
                        if (((class_2096.class_2100)entry.getValue()).method_9054(i)) continue;
                        return false;
                    }
                    return true;
                });
            }
            reader.setSelectsScores(true);
        }, reader -> !reader.selectsScores(), (class_2561)class_2561.method_43471((String)"argument.entity.options.scores.description"));
        CEntitySelectorOptions.putOption("advancements", reader -> {
            StringReader stringReader = reader.getReader();
            HashMap<class_2960, Predicate<class_167>> map = new HashMap<class_2960, Predicate<class_167>>();
            stringReader.expect('{');
            stringReader.skipWhitespace();
            while (stringReader.canRead() && stringReader.peek() != '}') {
                stringReader.skipWhitespace();
                class_2960 identifier = class_2960.method_12835((StringReader)stringReader);
                stringReader.skipWhitespace();
                stringReader.expect('=');
                stringReader.skipWhitespace();
                if (stringReader.canRead() && stringReader.peek() == '{') {
                    HashMap map2 = Maps.newHashMap();
                    stringReader.skipWhitespace();
                    stringReader.expect('{');
                    stringReader.skipWhitespace();
                    while (stringReader.canRead() && stringReader.peek() != '}') {
                        stringReader.skipWhitespace();
                        String string = stringReader.readUnquotedString();
                        stringReader.skipWhitespace();
                        stringReader.expect('=');
                        stringReader.skipWhitespace();
                        boolean bl = stringReader.readBoolean();
                        map2.put(string, criterionProgress -> criterionProgress.method_784() == bl);
                        stringReader.skipWhitespace();
                        if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                        stringReader.skip();
                    }
                    stringReader.skipWhitespace();
                    stringReader.expect('}');
                    stringReader.skipWhitespace();
                    map.put(identifier, advancementProgress -> {
                        for (Map.Entry entry : map2.entrySet()) {
                            class_178 criterionProgress = advancementProgress.method_737((String)entry.getKey());
                            if (criterionProgress != null && ((Predicate)entry.getValue()).test(criterionProgress)) continue;
                            return false;
                        }
                        return true;
                    });
                } else {
                    boolean map2 = stringReader.readBoolean();
                    map.put(identifier, advancementProgress -> advancementProgress.method_740() == map2);
                }
                stringReader.skipWhitespace();
                if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                stringReader.skip();
            }
            stringReader.expect('}');
            if (!map.isEmpty()) {
                reader.setPredicate(entity -> false);
                reader.setIncludesNonPlayers(false);
            }
            reader.setSelectsAdvancements(true);
        }, reader -> !reader.selectsAdvancements(), (class_2561)class_2561.method_43471((String)"argument.entity.options.advancements.description"));
        CEntitySelectorOptions.putOption("predicate", reader -> reader.setPredicate(entity -> false), reader -> true, (class_2561)class_2561.method_43471((String)"argument.entity.options.predicate.description"));
    }

    public static SelectorHandler getHandler(CEntitySelectorReader reader, String option, int restoreCursor) throws CommandSyntaxException {
        SelectorOption selectorOption = OPTIONS.get(option);
        if (selectorOption != null) {
            if (selectorOption.condition.test(reader)) {
                return selectorOption.handler;
            }
            throw INAPPLICABLE_OPTION_EXCEPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)option);
        }
        reader.getReader().setCursor(restoreCursor);
        throw UNKNOWN_OPTION_EXCEPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)option);
    }

    public static void suggestOptions(CEntitySelectorReader reader, SuggestionsBuilder suggestionBuilder) {
        String string = suggestionBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, SelectorOption> entry : OPTIONS.entrySet()) {
            if (!entry.getValue().condition.test(reader) || !entry.getKey().toLowerCase(Locale.ROOT).startsWith(string)) continue;
            suggestionBuilder.suggest(entry.getKey() + "=", (Message)entry.getValue().description);
        }
    }

    private static class SelectorOption {
        public final SelectorHandler handler;
        public final Predicate<CEntitySelectorReader> condition;
        public final class_2561 description;

        SelectorOption(SelectorHandler handler, Predicate<CEntitySelectorReader> condition, class_2561 description) {
            this.handler = handler;
            this.condition = condition;
            this.description = description;
        }
    }

    public static interface SelectorHandler {
        public void handle(CEntitySelectorReader var1) throws CommandSyntaxException;
    }
}

