/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.xpple.clientarguments.arguments.CEntityArgumentType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_2096;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_5575;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

public class CEntitySelector {
    private static final class_5575<class_1297, ?> PASSTHROUGH_FILTER = new class_5575<class_1297, class_1297>(){

        public class_1297 downcast(class_1297 entity) {
            return entity;
        }

        public Class<? extends class_1297> method_31794() {
            return class_1297.class;
        }
    };
    private final int limit;
    private final boolean includesNonPlayers;
    private final Predicate<class_1297> basePredicate;
    private final class_2096.class_2099 distance;
    private final Function<class_243, class_243> positionOffset;
    @Nullable
    private final class_238 box;
    private final BiConsumer<class_243, List<? extends class_1297>> sorter;
    private final boolean senderOnly;
    @Nullable
    private final String playerName;
    @Nullable
    private final UUID uuid;
    private final class_5575<class_1297, ?> entityFilter;
    private final boolean usesAt;

    public CEntitySelector(int count, boolean includesNonPlayers, Predicate<class_1297> basePredicate, class_2096.class_2099 distance, Function<class_243, class_243> positionOffset, @Nullable class_238 box, BiConsumer<class_243, List<? extends class_1297>> sorter, boolean senderOnly, @Nullable String playerName, @Nullable UUID uuid, @Nullable class_1299<?> type, boolean usesAt) {
        this.limit = count;
        this.includesNonPlayers = includesNonPlayers;
        this.basePredicate = basePredicate;
        this.distance = distance;
        this.positionOffset = positionOffset;
        this.box = box;
        this.sorter = sorter;
        this.senderOnly = senderOnly;
        this.playerName = playerName;
        this.uuid = uuid;
        this.entityFilter = type == null ? PASSTHROUGH_FILTER : type;
        this.usesAt = usesAt;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean includesNonPlayers() {
        return this.includesNonPlayers;
    }

    public boolean isSenderOnly() {
        return this.senderOnly;
    }

    public boolean usesAt() {
        return this.usesAt;
    }

    public class_1297 getEntity(FabricClientCommandSource source) throws CommandSyntaxException {
        List<? extends class_1297> list = this.getEntities(source);
        if (list.isEmpty()) {
            throw CEntityArgumentType.ENTITY_NOT_FOUND_EXCEPTION.create();
        }
        if (list.size() > 1) {
            throw CEntityArgumentType.TOO_MANY_ENTITIES_EXCEPTION.create();
        }
        return list.get(0);
    }

    public List<? extends class_1297> getEntities(FabricClientCommandSource source) throws CommandSyntaxException {
        if (!this.includesNonPlayers) {
            return this.getPlayers(source);
        }
        if (this.playerName != null) {
            class_742 abstractClientPlayerEntity = Streams.stream((Iterable)source.getWorld().method_18112()).filter(entity -> entity instanceof class_742).map(entity -> (class_742)entity).filter(abstractPlayer -> abstractPlayer.method_5477().getString().equals(this.playerName)).findAny().orElse(null);
            return abstractClientPlayerEntity == null ? Collections.emptyList() : Lists.newArrayList((Object[])new class_742[]{abstractClientPlayerEntity});
        }
        if (this.uuid != null) {
            class_1297 foundEntity = Streams.stream((Iterable)source.getWorld().method_18112()).filter(entity -> entity.method_5667().equals(this.uuid)).findAny().orElse(null);
            return foundEntity == null ? Collections.emptyList() : Lists.newArrayList((Object[])new class_1297[]{foundEntity});
        }
        class_243 pos = this.positionOffset.apply(source.getPosition());
        Predicate<class_1297> predicate = this.getPositionPredicate(pos);
        if (this.senderOnly) {
            if (source.getEntity() != null && predicate.test(source.getEntity())) {
                return Lists.newArrayList((Object[])new class_1297[]{source.getEntity()});
            }
            return Collections.emptyList();
        }
        ArrayList<class_1297> entity2 = new ArrayList<class_1297>();
        this.appendEntitiesFromWorld(entity2, source.getWorld(), pos, predicate);
        return this.getEntities(pos, entity2);
    }

    private void appendEntitiesFromWorld(List<class_1297> result, class_638 clientWorld, class_243 pos, Predicate<class_1297> predicate) {
        if (this.box != null) {
            result.addAll(clientWorld.method_18023(this.entityFilter, this.box.method_997(pos), predicate));
        } else {
            clientWorld.method_18112().forEach(entity -> {
                if (predicate.test((class_1297)entity)) {
                    result.add((class_1297)entity);
                }
                if (entity instanceof class_1510) {
                    class_1510 enderDragon = (class_1510)entity;
                    for (class_1508 bodyPart : enderDragon.method_5690()) {
                        class_1297 e = (class_1297)this.entityFilter.method_31796((Object)bodyPart);
                        if (e == null || !predicate.test(e)) continue;
                        result.add(e);
                    }
                }
            });
        }
    }

    public class_742 getPlayer(FabricClientCommandSource source) throws CommandSyntaxException {
        List<class_742> list = this.getPlayers(source);
        if (list.size() != 1) {
            throw CEntityArgumentType.PLAYER_NOT_FOUND_EXCEPTION.create();
        }
        return list.get(0);
    }

    public List<class_742> getPlayers(FabricClientCommandSource source) throws CommandSyntaxException {
        if (this.playerName != null) {
            class_742 abstractClientPlayerEntity = Streams.stream((Iterable)source.getWorld().method_18112()).filter(entity -> entity instanceof class_742).map(entity -> (class_742)entity).filter(abstractPlayer -> abstractPlayer.method_5477().getString().equals(this.playerName)).findAny().orElse(null);
            return abstractClientPlayerEntity == null ? Collections.emptyList() : Lists.newArrayList((Object[])new class_742[]{abstractClientPlayerEntity});
        }
        if (this.uuid != null) {
            class_742 abstractClientPlayerEntity = Streams.stream((Iterable)source.getWorld().method_18112()).filter(entity -> entity instanceof class_742).map(entity -> (class_742)entity).filter(entity -> entity.method_5667().equals(this.uuid)).findAny().orElse(null);
            return abstractClientPlayerEntity == null ? Collections.emptyList() : Lists.newArrayList((Object[])new class_742[]{abstractClientPlayerEntity});
        }
        class_243 pos = this.positionOffset.apply(source.getPosition());
        Predicate<class_1297> predicate = this.getPositionPredicate(pos);
        if (this.senderOnly) {
            class_742 player;
            class_1297 class_12972 = source.getEntity();
            if (class_12972 instanceof class_742 && predicate.test((class_1297)(player = (class_742)class_12972))) {
                return Lists.newArrayList((Object[])new class_742[]{player});
            }
            return Collections.emptyList();
        }
        List entities = source.getWorld().method_18456().stream().filter(predicate).collect(Collectors.toList());
        return this.getEntities(pos, entities);
    }

    private Predicate<class_1297> getPositionPredicate(class_243 pos) {
        Predicate<class_1297> predicate = this.basePredicate;
        if (this.box != null) {
            class_238 box = this.box.method_997(pos);
            predicate = predicate.and(entity -> box.method_994(entity.method_5829()));
        }
        if (!this.distance.method_9041()) {
            predicate = predicate.and(entity -> this.distance.method_9045(entity.method_5707(pos)));
        }
        return predicate;
    }

    private <T extends class_1297> List<T> getEntities(class_243 pos, List<T> entities) {
        if (entities.size() > 1) {
            this.sorter.accept(pos, entities);
        }
        return entities.subList(0, Math.min(this.limit, entities.size()));
    }

    public static class_2561 getNames(List<? extends class_1297> entities) {
        return class_2564.method_10884(entities, class_1297::method_5476);
    }
}

