/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.google.common.collect.Iterables;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.clientarguments.arguments.CEntitySelector;
import dev.xpple.clientarguments.arguments.CEntitySelectorReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_742;

public class CEntityArgumentType
implements ArgumentType<CEntitySelector> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "@e", "@e[type=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    public static final SimpleCommandExceptionType TOO_MANY_ENTITIES_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.entity.toomany"));
    public static final SimpleCommandExceptionType TOO_MANY_PLAYERS_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.player.toomany"));
    public static final SimpleCommandExceptionType PLAYER_SELECTOR_HAS_ENTITIES_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.player.entities"));
    public static final SimpleCommandExceptionType ENTITY_NOT_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.entity.notfound.entity"));
    public static final SimpleCommandExceptionType PLAYER_NOT_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.entity.notfound.player"));
    public static final SimpleCommandExceptionType NOT_ALLOWED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.entity.selector.not_allowed"));
    final boolean singleTarget;
    final boolean playersOnly;

    protected CEntityArgumentType(boolean singleTarget, boolean playersOnly) {
        this.singleTarget = singleTarget;
        this.playersOnly = playersOnly;
    }

    public static CEntityArgumentType entity() {
        return new CEntityArgumentType(true, false);
    }

    public static class_1297 getCEntity(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        return ((CEntitySelector)context.getArgument(name, CEntitySelector.class)).getEntity((FabricClientCommandSource)context.getSource());
    }

    public static CEntityArgumentType entities() {
        return new CEntityArgumentType(false, false);
    }

    public static CEntitySelector getCEntitySelector(CommandContext<FabricClientCommandSource> context, String name) {
        return (CEntitySelector)context.getArgument(name, CEntitySelector.class);
    }

    public static Collection<? extends class_1297> getCEntities(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        Collection<? extends class_1297> collection = CEntityArgumentType.getCOptionalEntities(context, name);
        if (collection.isEmpty()) {
            throw ENTITY_NOT_FOUND_EXCEPTION.create();
        }
        return collection;
    }

    public static Collection<? extends class_1297> getCOptionalEntities(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        return ((CEntitySelector)context.getArgument(name, CEntitySelector.class)).getEntities((FabricClientCommandSource)context.getSource());
    }

    public static Collection<class_742> getCOptionalPlayers(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        return ((CEntitySelector)context.getArgument(name, CEntitySelector.class)).getPlayers((FabricClientCommandSource)context.getSource());
    }

    public static CEntityArgumentType player() {
        return new CEntityArgumentType(true, true);
    }

    public static class_742 getCPlayer(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        return ((CEntitySelector)context.getArgument(name, CEntitySelector.class)).getPlayer((FabricClientCommandSource)context.getSource());
    }

    public static CEntityArgumentType players() {
        return new CEntityArgumentType(false, true);
    }

    public static Collection<class_742> getCPlayers(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        List<class_742> list = ((CEntitySelector)context.getArgument(name, CEntitySelector.class)).getPlayers((FabricClientCommandSource)context.getSource());
        if (list.isEmpty()) {
            throw PLAYER_NOT_FOUND_EXCEPTION.create();
        }
        return list;
    }

    public CEntitySelector parse(StringReader stringReader) throws CommandSyntaxException {
        CEntitySelectorReader entitySelectorReader = new CEntitySelectorReader(stringReader);
        CEntitySelector entitySelector = entitySelectorReader.read();
        if (entitySelector.getLimit() > 1 && this.singleTarget) {
            if (this.playersOnly) {
                stringReader.setCursor(0);
                throw TOO_MANY_PLAYERS_EXCEPTION.createWithContext((ImmutableStringReader)stringReader);
            }
            stringReader.setCursor(0);
            throw TOO_MANY_ENTITIES_EXCEPTION.createWithContext((ImmutableStringReader)stringReader);
        }
        if (entitySelector.includesNonPlayers() && this.playersOnly && !entitySelector.isSenderOnly()) {
            stringReader.setCursor(0);
            throw PLAYER_SELECTOR_HAS_ENTITIES_EXCEPTION.createWithContext((ImmutableStringReader)stringReader);
        }
        return entitySelector;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof class_2172) {
            class_2172 commandSource = (class_2172)object;
            StringReader stringReader = new StringReader(builder.getInput());
            stringReader.setCursor(builder.getStart());
            CEntitySelectorReader entitySelectorReader = new CEntitySelectorReader(stringReader, true);
            try {
                entitySelectorReader.read();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return entitySelectorReader.listSuggestions(builder, (SuggestionsBuilder builderx) -> {
                Collection collection = commandSource.method_9262();
                Collection iterable = this.playersOnly ? collection : Iterables.concat((Iterable)collection, (Iterable)commandSource.method_9269());
                class_2172.method_9265((Iterable)iterable, (SuggestionsBuilder)builderx);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

