/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2172;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class CEntityAnchorArgumentType
implements ArgumentType<EntityAnchor> {
    private static final Collection<String> EXAMPLES = Arrays.asList("eyes", "feet");
    private static final DynamicCommandExceptionType INVALID_ANCHOR_EXCEPTION = new DynamicCommandExceptionType(name -> class_2561.method_43469((String)"argument.anchor.invalid", (Object[])new Object[]{name}));

    public static CEntityAnchorArgumentType entityAnchor() {
        return new CEntityAnchorArgumentType();
    }

    public static EntityAnchor getCEntityAnchor(CommandContext<FabricClientCommandSource> context, String name) {
        return (EntityAnchor)((Object)context.getArgument(name, EntityAnchor.class));
    }

    public EntityAnchor parse(StringReader stringReader) throws CommandSyntaxException {
        int cursor = stringReader.getCursor();
        String string = stringReader.readUnquotedString();
        EntityAnchor entityAnchor = EntityAnchor.fromId(string);
        if (entityAnchor == null) {
            stringReader.setCursor(cursor);
            throw INVALID_ANCHOR_EXCEPTION.createWithContext((ImmutableStringReader)stringReader, (Object)string);
        }
        return entityAnchor;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(EntityAnchor.ANCHORS.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static enum EntityAnchor {
        FEET("feet", (pos, entity) -> pos),
        EYES("eyes", (pos, entity) -> new class_243(pos.field_1352, pos.field_1351 + (double)entity.method_5751(), pos.field_1350));

        static final Map<String, EntityAnchor> ANCHORS;
        private final String id;
        private final BiFunction<class_243, class_1297, class_243> offset;

        private EntityAnchor(String id, BiFunction<class_243, class_1297, class_243> offset) {
            this.id = id;
            this.offset = offset;
        }

        @Nullable
        public static EntityAnchor fromId(String id) {
            return ANCHORS.get(id);
        }

        public class_243 positionAt(class_1297 entity) {
            return this.offset.apply(entity.method_19538(), entity);
        }

        public class_243 positionAt(FabricClientCommandSource source) {
            class_1297 entity = source.getEntity();
            return entity == null ? source.getPosition() : this.offset.apply(source.getPosition(), entity);
        }

        static {
            ANCHORS = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
                EntityAnchor[] var1;
                for (EntityAnchor entityAnchor : var1 = EntityAnchor.values()) {
                    map.put(entityAnchor.id, entityAnchor);
                }
            });
        }
    }
}

