/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2769;
import net.minecraft.class_6885;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class CBlockPredicateArgumentType
implements ArgumentType<BlockPredicate> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stone", "minecraft:stone", "stone[foo=bar]", "#stone", "#stone[foo=bar]{baz=nbt}");
    private final class_7225<class_2248> registryWrapper;

    public CBlockPredicateArgumentType(class_7157 commandRegistryAccess) {
        this.registryWrapper = commandRegistryAccess.method_41699(class_7924.field_41254);
    }

    public static CBlockPredicateArgumentType blockPredicate(class_7157 commandRegistryAccess) {
        return new CBlockPredicateArgumentType(commandRegistryAccess);
    }

    public BlockPredicate parse(StringReader stringReader) throws CommandSyntaxException {
        return CBlockPredicateArgumentType.parse(this.registryWrapper, stringReader);
    }

    public static BlockPredicate parse(class_7225<class_2248> registryWrapper, StringReader reader) throws CommandSyntaxException {
        return (BlockPredicate)class_2259.method_41960(registryWrapper, (StringReader)reader, (boolean)true).map(result -> new StatePredicate(result.comp_622(), result.comp_623().keySet(), result.comp_624()), result -> new TagPredicate((class_6885<class_2248>)result.comp_625(), result.comp_626(), result.comp_627()));
    }

    public static Predicate<class_2694> getCBlockPredicate(CommandContext<FabricClientCommandSource> context, String name) {
        return (Predicate)context.getArgument(name, BlockPredicate.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2259.method_9666(this.registryWrapper, (SuggestionsBuilder)builder, (boolean)true, (boolean)true);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static interface BlockPredicate
    extends Predicate<class_2694> {
        public boolean hasNbt();
    }

    static class TagPredicate
    implements BlockPredicate {
        private final class_6885<class_2248> tag;
        @Nullable
        private final class_2487 nbt;
        private final Map<String, String> properties;

        TagPredicate(class_6885<class_2248> tag, Map<String, String> properties, @Nullable class_2487 nbt) {
            this.tag = tag;
            this.properties = properties;
            this.nbt = nbt;
        }

        @Override
        public boolean test(class_2694 cachedBlockPosition) {
            class_2680 blockState = cachedBlockPosition.method_11681();
            if (!blockState.method_40143(this.tag)) {
                return false;
            }
            for (Map.Entry<String, String> stringStringEntry : this.properties.entrySet()) {
                class_2769 property = blockState.method_26204().method_9595().method_11663(stringStringEntry.getKey());
                if (property == null) {
                    return false;
                }
                Comparable comparable = property.method_11900(stringStringEntry.getValue()).orElse(null);
                if (comparable == null) {
                    return false;
                }
                if (blockState.method_11654(property) == comparable) continue;
                return false;
            }
            if (this.nbt == null) {
                return true;
            }
            class_2586 blockEntity = cachedBlockPosition.method_11680();
            return blockEntity != null && class_2512.method_10687((class_2520)this.nbt, (class_2520)blockEntity.method_38242(), (boolean)true);
        }

        @Override
        public boolean hasNbt() {
            return this.nbt != null;
        }
    }

    static class StatePredicate
    implements BlockPredicate {
        private final class_2680 state;
        private final Set<class_2769<?>> properties;
        @Nullable
        private final class_2487 nbt;

        public StatePredicate(class_2680 state, Set<class_2769<?>> properties, @Nullable class_2487 nbt) {
            this.state = state;
            this.properties = properties;
            this.nbt = nbt;
        }

        @Override
        public boolean test(class_2694 cachedBlockPosition) {
            class_2680 blockState = cachedBlockPosition.method_11681();
            if (!blockState.method_27852(this.state.method_26204())) {
                return false;
            }
            for (class_2769<?> value : this.properties) {
                if (blockState.method_11654(value) == this.state.method_11654(value)) continue;
                return false;
            }
            if (this.nbt == null) {
                return true;
            }
            class_2586 blockEntity = cachedBlockPosition.method_11680();
            return blockEntity != null && class_2512.method_10687((class_2520)this.nbt, (class_2520)blockEntity.method_38242(), (boolean)true);
        }

        @Override
        public boolean hasNbt() {
            return this.nbt != null;
        }
    }
}

