/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.clientarguments.arguments.CDefaultPosArgument;
import dev.xpple.clientarguments.arguments.CLookingPosArgument;
import dev.xpple.clientarguments.arguments.CPosArgument;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_638;

public class CBlockPosArgumentType
implements ArgumentType<CPosArgument> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0 0", "~ ~ ~", "^ ^ ^", "^1 ^ ^-5", "~0.5 ~1 ~-5");
    public static final SimpleCommandExceptionType UNLOADED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.pos.unloaded"));
    public static final SimpleCommandExceptionType OUT_OF_WORLD_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.pos.outofworld"));
    public static final SimpleCommandExceptionType OUT_OF_BOUNDS_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.pos.outofbounds"));

    public static CBlockPosArgumentType blockPos() {
        return new CBlockPosArgumentType();
    }

    public static class_2338 getCLoadedBlockPos(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        class_638 clientWorld = ((FabricClientCommandSource)context.getSource()).getWorld();
        return CBlockPosArgumentType.getCLoadedBlockPos(context, clientWorld, name);
    }

    public static class_2338 getCLoadedBlockPos(CommandContext<FabricClientCommandSource> context, class_638 world, String name) throws CommandSyntaxException {
        class_2338 blockPos = CBlockPosArgumentType.getCBlockPos(context, name);
        class_1923 chunkPos = new class_1923(blockPos);
        if (!world.method_2935().method_12123(chunkPos.field_9181, chunkPos.field_9180)) {
            throw UNLOADED_EXCEPTION.create();
        }
        if (!world.method_24794(blockPos)) {
            throw OUT_OF_WORLD_EXCEPTION.create();
        }
        return blockPos;
    }

    public static class_2338 getCBlockPos(CommandContext<FabricClientCommandSource> context, String name) {
        return ((CPosArgument)context.getArgument(name, CPosArgument.class)).toAbsoluteBlockPos((FabricClientCommandSource)context.getSource());
    }

    public static class_2338 getCValidBlockPos(CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        class_2338 blockPos = CBlockPosArgumentType.getCBlockPos(context, name);
        if (!class_1937.method_25953((class_2338)blockPos)) {
            throw OUT_OF_BOUNDS_EXCEPTION.create();
        }
        return blockPos;
    }

    public CPosArgument parse(StringReader stringReader) throws CommandSyntaxException {
        return stringReader.canRead() && stringReader.peek() == '^' ? CLookingPosArgument.parse(stringReader) : CDefaultPosArgument.parse(stringReader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (!(context.getSource() instanceof class_2172)) {
            return Suggestions.empty();
        }
        String string = builder.getRemaining();
        Set<class_2172.class_2173> collection = !string.isEmpty() && string.charAt(0) == '^' ? Collections.singleton(class_2172.class_2173.field_9834) : ((class_2172)context.getSource()).method_17771();
        return class_2172.method_9260((String)string, collection, (SuggestionsBuilder)builder, (Predicate)class_2170.method_9238(this::parse));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

