/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.clientarguments.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2278;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public class CAngleArgumentType
implements ArgumentType<Angle> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0", "~", "~-5");
    public static final SimpleCommandExceptionType INCOMPLETE_ANGLE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.angle.incomplete"));
    public static final SimpleCommandExceptionType INVALID_ANGLE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.angle.invalid"));

    public static CAngleArgumentType angle() {
        return new CAngleArgumentType();
    }

    public static float getCAngle(CommandContext<FabricClientCommandSource> context, String name) {
        return ((Angle)context.getArgument(name, Angle.class)).getAngle((FabricClientCommandSource)context.getSource());
    }

    public Angle parse(StringReader stringReader) throws CommandSyntaxException {
        float angle;
        if (!stringReader.canRead()) {
            throw INCOMPLETE_ANGLE_EXCEPTION.createWithContext((ImmutableStringReader)stringReader);
        }
        boolean relative = class_2278.method_9742((StringReader)stringReader);
        float f = angle = stringReader.canRead() && stringReader.peek() != ' ' ? stringReader.readFloat() : 0.0f;
        if (!Float.isNaN(angle) && !Float.isInfinite(angle)) {
            return new Angle(angle, relative);
        }
        throw INVALID_ANGLE_EXCEPTION.createWithContext((ImmutableStringReader)stringReader);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static final class Angle {
        private final float angle;
        private final boolean relative;

        Angle(float angle, boolean relative) {
            this.angle = angle;
            this.relative = relative;
        }

        public float getAngle(FabricClientCommandSource source) {
            return class_3532.method_15393((float)(this.relative ? this.angle + source.getRotation().field_1342 : this.angle));
        }
    }
}

