/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.unsafe;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.impl.ModContainerImpl;
import net.fabricmc.loader.impl.metadata.EntrypointMetadata;

public class DynamicEntry {
    public static <T> void execute(String name, Class<T> entrypointType, Consumer<ConsumableEntrypoint<T>> onExecute) {
        ArrayList<ConsumableEntrypoint<T>> targets = new ArrayList<ConsumableEntrypoint<T>>();
        for (EntrypointContainer entrypointContainer : DynamicEntry.getEntrypointTargets(name)) {
            try {
                targets.add(new ConsumableEntrypoint<T>(entrypointType.cast(Class.forName(entrypointContainer.entrypoint).getConstructor(new Class[0]).newInstance(new Object[0])), entrypointContainer.mod));
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalArgumentException(String.format("class %s specified in the %s entrypoint of mod %s does not exist", entrypointContainer.entrypoint, name, entrypointContainer.mod), exception);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException exception) {
                throw new IllegalStateException(String.format("class %s specified in the %s entrypoint of mod %s cannot be instantiated", entrypointContainer.entrypoint, name, entrypointContainer.mod), exception);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(String.format("an error was encountered during the instantiation of the %s entrypoint class %s", name, entrypointContainer.entrypoint), exception);
            }
        }
        for (ConsumableEntrypoint consumableEntrypoint : targets) {
            onExecute.accept(consumableEntrypoint);
        }
    }

    private static Collection<EntrypointContainer> getEntrypointTargets(String entrypoint) {
        LinkedList<EntrypointContainer> entrypoints = new LinkedList<EntrypointContainer>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            List modEntrypoints = ((ModContainerImpl)mod).getMetadata().getEntrypoints(entrypoint);
            if (modEntrypoints == null) continue;
            for (EntrypointMetadata metadata : modEntrypoints) {
                entrypoints.add(new EntrypointContainer(metadata.getValue(), mod.getMetadata().getId()));
            }
        }
        return entrypoints;
    }

    record EntrypointContainer(String entrypoint, String mod) {
    }

    public record ConsumableEntrypoint<T>(T instance, String modId) {
    }
}

