/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.io;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.exception.ConfigReadException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import dev.toma.configuration.config.io.FileWatchManager;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_128;
import net.minecraft.class_148;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class ConfigIO {
    public static final Marker MARKER = MarkerManager.getMarker((String)"IO");
    public static final FileWatchManager FILE_WATCH_MANAGER = new FileWatchManager();

    public static void processConfig(ConfigHolder<?> holder) {
        Configuration.LOGGER.debug(MARKER, "Starting processing of config {}", (Object)holder.getConfigId());
        ConfigIO.processSafely(holder, () -> {
            File file = ConfigIO.getConfigFile(holder);
            if (file.exists()) {
                try {
                    ConfigIO.readConfig(holder);
                }
                catch (IOException e) {
                    Configuration.LOGGER.error(MARKER, "Config read failed for config ID {}, will create default config file", (Object)holder.getConfigId());
                }
            }
            try {
                ConfigIO.writeConfig(holder);
            }
            catch (IOException e) {
                Configuration.LOGGER.fatal(MARKER, "Couldn't write config {}, aborting mod startup", (Object)holder.getConfigId());
                throw new RuntimeException("Config write failed", e);
            }
        });
        Configuration.LOGGER.debug(MARKER, "Processing of config {} has finished", (Object)holder.getConfigId());
    }

    public static void reloadClientValues(ConfigHolder<?> configHolder) {
        ConfigIO.processSafely(configHolder, () -> {
            try {
                ConfigIO.readConfig(configHolder);
            }
            catch (IOException e) {
                Configuration.LOGGER.error(MARKER, "Failed to read config file {}", (Object)configHolder.getConfigId());
            }
        });
    }

    public static void saveClientValues(ConfigHolder<?> configHolder) {
        ConfigIO.processSafely(configHolder, () -> {
            try {
                ConfigIO.writeConfig(configHolder);
            }
            catch (IOException e) {
                Configuration.LOGGER.error(MARKER, "Failed to write config file {}", (Object)configHolder.getConfigId());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processSafely(ConfigHolder<?> holder, Runnable action) {
        try {
            Object object = holder.getLock();
            synchronized (object) {
                action.run();
            }
        }
        catch (Exception e) {
            Configuration.LOGGER.fatal(MARKER, "Error loading config {} due to critical error '{}'. Report this issue to this config's owner!", (Object)holder.getConfigId(), (Object)e.getMessage());
            throw new class_148(class_128.method_560((Throwable)e, (String)("Config " + holder.getConfigId() + " failed. Report issue to config owner")));
        }
    }

    private static void readConfig(ConfigHolder<?> holder) throws IOException {
        Configuration.LOGGER.debug(MARKER, "Reading config {}", (Object)holder.getConfigId());
        IConfigFormat format = holder.getFormat().createFormat();
        File file = ConfigIO.getConfigFile(holder);
        if (!file.exists()) {
            return;
        }
        try {
            format.readFile(file);
            holder.values().forEach(value -> value.deserializeValue(format));
        }
        catch (ConfigReadException e) {
            Configuration.LOGGER.error(MARKER, "Config read failed, using default values", (Throwable)e);
        }
    }

    public static void writeConfig(ConfigHolder<?> holder) throws IOException {
        Configuration.LOGGER.debug(MARKER, "Writing config {}", (Object)holder.getConfigId());
        File file = ConfigIO.getConfigFile(holder);
        File dir = file.getParentFile();
        if (dir.mkdirs()) {
            Configuration.LOGGER.debug(MARKER, "Created file directories at {}", (Object)dir.getAbsolutePath());
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new RuntimeException("Config file create failed");
        }
        IConfigFormatHandler handler = holder.getFormat();
        IConfigFormat format = handler.createFormat();
        holder.values().forEach(value -> value.serializeValue(format));
        format.writeFile(file);
    }

    public static File getConfigFile(ConfigHolder<?> holder) {
        IConfigFormatHandler handler = holder.getFormat();
        String filename = holder.getFilename();
        return new File("./config/" + filename + "." + handler.fileExt());
    }
}

