/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client;

import dev.toma.configuration.client.DisplayAdapter;
import dev.toma.configuration.config.adapter.TypeMatcher;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class DisplayAdapterManager {
    private static final Map<TypeMatcher, DisplayAdapter> ADAPTER_MAP = new HashMap<TypeMatcher, DisplayAdapter>();

    public static DisplayAdapter forType(Class<?> type) {
        return ADAPTER_MAP.entrySet().stream().filter(entry -> ((TypeMatcher)entry.getKey()).test(type)).sorted(Comparator.comparingInt(value -> ((TypeMatcher)value.getKey()).priority())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public static void registerDisplayAdapter(TypeMatcher matcher, DisplayAdapter adapter) {
        if (ADAPTER_MAP.put(matcher, adapter) != null) {
            throw new IllegalArgumentException("Duplicate type matcher with id: " + matcher.getIdentifier());
        }
    }

    static {
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchBoolean(), DisplayAdapter.booleanValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchCharacter(), DisplayAdapter.characterValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchInteger(), DisplayAdapter.integerValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchLong(), DisplayAdapter.longValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchFloat(), DisplayAdapter.floatValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchDouble(), DisplayAdapter.doubleValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchString(), DisplayAdapter.stringValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchBooleanArray(), DisplayAdapter.booleanArrayValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchIntegerArray(), DisplayAdapter.integerArrayValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchLongArray(), DisplayAdapter.longArrayValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchFloatArray(), DisplayAdapter.floatArrayValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchDoubleArray(), DisplayAdapter.doubleArrayValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchStringArray(), DisplayAdapter.stringArrayValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchEnum(), DisplayAdapter.enumValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchEnumArray(), DisplayAdapter.enumArrayValue());
        DisplayAdapterManager.registerDisplayAdapter(TypeMatcher.matchObject(), DisplayAdapter.objectValue());
    }
}

