/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.tag.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.tag.client.ClientTagsImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7475;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ClientTagsLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-client-tags-api-v1");

    public static LoadedTag loadTag(final class_6862<?> tagKey) {
        HashSet tags = new HashSet();
        HashSet<Path> tagFiles = ClientTagsLoader.getTagFiles(tagKey.comp_326(), tagKey.comp_327());
        for (Path tagPath : tagFiles) {
            try {
                BufferedReader tagReader = Files.newBufferedReader(tagPath);
                try {
                    JsonElement jsonElement = JsonParser.parseReader((Reader)tagReader);
                    class_7475 maybeTagFile = class_7475.field_39269.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement)).result().orElse(null);
                    if (maybeTagFile == null) continue;
                    if (maybeTagFile.comp_812()) {
                        tags.clear();
                    }
                    tags.addAll(maybeTagFile.comp_811());
                }
                finally {
                    if (tagReader == null) continue;
                    tagReader.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Error loading tag: " + String.valueOf(tagKey), (Throwable)e);
            }
        }
        HashSet completeIds = new HashSet();
        final HashSet immediateChildIds = new HashSet();
        final HashSet immediateChildTags = new HashSet();
        for (class_3497 tagEntry : tags) {
            tagEntry.method_26790((class_3497.class_7474)new class_3497.class_7474<class_2960>(){

                @Nullable
                public class_2960 direct(class_2960 id) {
                    immediateChildIds.add(id);
                    return id;
                }

                @Nullable
                public Collection<class_2960> method_43949(class_2960 id) {
                    class_6862 tag = class_6862.method_40092((class_5321)tagKey.comp_326(), (class_2960)id);
                    immediateChildTags.add(tag);
                    return ClientTagsImpl.getOrCreatePartiallySyncedTag(tag).completeIds;
                }
            }, completeIds::add);
        }
        immediateChildTags.remove(tagKey);
        return new LoadedTag(Collections.unmodifiableSet(completeIds), Collections.unmodifiableSet(immediateChildTags), Collections.unmodifiableSet(immediateChildIds));
    }

    private static HashSet<Path> getTagFiles(class_5321<? extends class_2378<?>> registryKey, class_2960 identifier) {
        return ClientTagsLoader.getTagFiles(class_3505.method_40099(registryKey), identifier);
    }

    private static HashSet<Path> getTagFiles(String tagType, class_2960 identifier) {
        String tagFile = "data/%s/%s/%s.json".formatted(identifier.method_12836(), tagType, identifier.method_12832());
        return ClientTagsLoader.getResourcePaths(tagFile);
    }

    private static HashSet<Path> getResourcePaths(String path) {
        HashSet<Path> out = new HashSet<Path>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            mod.findPath(path).ifPresent(out::add);
        }
        return out;
    }

    @Environment(value=EnvType.CLIENT)
    public record LoadedTag(Set<class_2960> completeIds, Set<class_6862<?>> immediateChildTags, Set<class_2960> immediateChildIds) {
    }
}

