/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.errornotifier.launch.early;

import me.shedaniel.errornotifier.launch.early.BakedGlyph;
import me.shedaniel.errornotifier.launch.early.Glyph;
import me.shedaniel.errornotifier.launch.early.Image;
import me.shedaniel.errornotifier.launch.early.Texture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class FontTexture
implements Texture {
    private static final int SIZE = 256;
    private final String name;
    private final boolean colored;
    private final Node root;
    private int id;
    private Image image;

    public FontTexture(String name, boolean colored) {
        this.name = name;
        this.colored = colored;
        this.root = new Node(0, 0, 256, 256);
        this.id = GL11.glGenTextures();
        this.image = new Image(256, 256);
    }

    public void close() {
        GL11.glDeleteTextures((int)this.id);
        this.id = -1;
    }

    @Nullable
    public BakedGlyph add(Glyph rawGlyph) {
        if (rawGlyph.isColored() != this.colored) {
            return null;
        }
        Node node = this.root.insert(rawGlyph);
        if (node != null) {
            rawGlyph.upload(this.getId(), node.x, node.y, this.image);
            this.upload(false, true);
            return new BakedGlyph(this.name, ((float)node.x + 0.01f) / 256.0f, ((float)node.x - 0.01f + (float)rawGlyph.getPixelWidth()) / 256.0f, ((float)node.y + 0.01f) / 256.0f, ((float)node.y - 0.01f + (float)rawGlyph.getPixelHeight()) / 256.0f, rawGlyph.getLeft(), rawGlyph.getRight(), rawGlyph.getUp(), rawGlyph.getDown());
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void upload(boolean blur, boolean wrap) {
        this.image.upload(this.id, blur, wrap);
    }

    @Environment(value=EnvType.CLIENT)
    static class Node {
        final int x;
        final int y;
        private final int width;
        private final int height;
        @Nullable
        private Node left;
        @Nullable
        private Node right;
        private boolean occupied;

        Node(int i, int j, int k, int l) {
            this.x = i;
            this.y = j;
            this.width = k;
            this.height = l;
        }

        @Nullable
        Node insert(Glyph rawGlyph) {
            if (this.left != null && this.right != null) {
                Node node = this.left.insert(rawGlyph);
                if (node == null) {
                    node = this.right.insert(rawGlyph);
                }
                return node;
            }
            if (this.occupied) {
                return null;
            }
            int i = rawGlyph.getPixelWidth();
            int j = rawGlyph.getPixelHeight();
            if (i <= this.width && j <= this.height) {
                if (i == this.width && j == this.height) {
                    this.occupied = true;
                    return this;
                }
                int k = this.width - i;
                int l = this.height - j;
                if (k > l) {
                    this.left = new Node(this.x, this.y, i, this.height);
                    this.right = new Node(this.x + i + 1, this.y, this.width - i - 1, this.height);
                } else {
                    this.left = new Node(this.x, this.y, this.width, j);
                    this.right = new Node(this.x, this.y + j + 1, this.width, this.height - j - 1);
                }
                return this.left.insert(rawGlyph);
            }
            return null;
        }
    }
}

