/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.errornotifier.launch;

import java.util.HashMap;
import java.util.Map;
import me.shedaniel.errornotifier.launch.EarlyShader;
import org.lwjgl.opengl.GL20;

public class EarlyShaderProgram {
    public static final Map<String, EarlyShaderProgram> SHADER_PROGRAM_MAP = new HashMap<String, EarlyShaderProgram>();
    private final int handle = GL20.glCreateProgram();

    static EarlyShaderProgram getProgram(String shaderName) {
        EarlyShaderProgram program = SHADER_PROGRAM_MAP.computeIfAbsent(shaderName, $ -> {
            EarlyShader vertexShader = EarlyShader.createVertexShader(shaderName);
            EarlyShader fragmentShader = EarlyShader.createFragmentShader(shaderName);
            EarlyShaderProgram p = new EarlyShaderProgram(vertexShader, fragmentShader);
            GL20.glDeleteShader((int)vertexShader.getHandle());
            GL20.glDeleteShader((int)fragmentShader.getHandle());
            return p;
        });
        if (!GL20.glIsProgram((int)program.handle)) {
            GL20.glValidateProgram((int)program.handle);
            program.delete();
            SHADER_PROGRAM_MAP.remove(shaderName);
            return EarlyShaderProgram.getProgram(shaderName);
        }
        return program;
    }

    public EarlyShaderProgram(EarlyShader vertexShader, EarlyShader fragmentShader) {
        GL20.glAttachShader((int)this.handle, (int)vertexShader.getHandle());
        GL20.glAttachShader((int)this.handle, (int)fragmentShader.getHandle());
        GL20.glLinkProgram((int)this.handle);
        String infoLog = GL20.glGetProgramInfoLog((int)this.handle, (int)512);
        System.out.println("Shader linkage status: " + infoLog);
    }

    void use() {
        GL20.glUseProgram((int)this.handle);
    }

    int getUniform(String uniformName) {
        return GL20.glGetUniformLocation((int)this.handle, (CharSequence)uniformName);
    }

    public void delete() {
        GL20.glDeleteProgram((int)this.handle);
    }
}

