/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.errornotifier.client;

import java.io.IOException;
import java.util.List;
import me.shedaniel.errornotifier.ForkingUtils;
import me.shedaniel.errornotifier.api.ErrorProvider;
import me.shedaniel.errornotifier.client.DynamicErrorFreeEntryListWidget;
import me.shedaniel.errornotifier.launch.EarlyGraphics;
import me.shedaniel.errornotifier.launch.EarlyWindowRenderer;

public class ErrorRenderer
implements EarlyWindowRenderer {
    public final List<ErrorProvider.ErrorComponent> errors;
    public StringEntryListWidget listWidget;

    public ErrorRenderer(List<ErrorProvider.ErrorComponent> errors) {
        this.errors = errors;
    }

    @Override
    public void render(EarlyGraphics graphics, double mouseX, double mouseY, float tickDelta) {
        this.listWidget = new StringEntryListWidget(graphics.getScaledWidth(), graphics.getScaledHeight(), 32, graphics.getScaledHeight());
        this.listWidget.addItem(new EmptyItem());
        this.listWidget.addItem(new TextItem("Errors:", -43691));
        for (ErrorProvider.ErrorComponent error : this.errors) {
            for (String s : graphics.splitString("- " + error.message().getMessage(), graphics.getScaledWidth() - 40)) {
                this.listWidget.addItem(new TextItem(s, -1));
            }
            String url = error.url();
            if (url == null) continue;
            for (String s : graphics.splitString(url, graphics.getScaledWidth() - 40)) {
                this.listWidget.addItem(new LinkItem(s, url));
            }
        }
        this.listWidget.addItem(new EmptyItem());
        this.listWidget.addItem(new EmptyItem());
        this.listWidget.addItem(new TextItem("Minecraft may not be launched in this state!", -6710887));
        this.listWidget.addItem(new TextItem("Please fix the issues and restart!", -6710887));
        for (StringItem child : this.listWidget.children()) {
            this.listWidget.max = Math.max(this.listWidget.max, child.getWidth(graphics));
        }
        this.listWidget.render(graphics, (int)mouseX, (int)mouseY, tickDelta);
        graphics.drawStringCenteredWithShadow("Startup Errors", graphics.getScaledWidth() / 2, 13, -1);
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int button) {
        if (this.listWidget != null) {
            this.listWidget.mouseClicked(mouseX, mouseY, button);
        }
    }

    private static class StringEntryListWidget
    extends DynamicErrorFreeEntryListWidget<StringItem> {
        private boolean inFocus;
        private int max = 80;

        public StringEntryListWidget(int width, int height, int startY, int endY) {
            super(width, height, startY, endY, "textures/gui/options_background.png");
        }

        public void creditsClearEntries() {
            this.clearItems();
        }

        private StringItem rei_getEntry(int int_1) {
            return (StringItem)this.children().get(int_1);
        }

        public void creditsAddEntry(StringItem entry) {
            this.addItem(entry);
        }

        @Override
        public int getItemWidth() {
            return this.max;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.width - 40;
        }
    }

    private static class EmptyItem
    extends StringItem {
        private EmptyItem() {
        }

        @Override
        public void render(EarlyGraphics matrixStack, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
        }

        @Override
        public int getItemHeight() {
            return 5;
        }

        @Override
        public int getWidth(EarlyGraphics graphics) {
            return 0;
        }
    }

    private static class TextItem
    extends StringItem {
        private String text;
        private int color;

        public TextItem(String text, int color) {
            this.text = text;
            this.color = color;
        }

        @Override
        public void render(EarlyGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            graphics.drawStringWithShadow(this.text, x + 5, y, this.color);
        }

        @Override
        public int getItemHeight() {
            return 12;
        }

        @Override
        public int getWidth(EarlyGraphics graphics) {
            return graphics.width(this.text) + 10;
        }
    }

    private class LinkItem
    extends StringItem {
        private String text;
        private String link;
        private boolean contains;

        public LinkItem(String text, String link) {
            this.text = text;
            this.link = link;
        }

        @Override
        public void render(EarlyGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            float width = graphics.drawStringWithShadow(this.text, x + 5, y, -14695425);
            if (this.contains) {
                graphics.fill(x + 5, y + 8, (int)((float)(x + 5) + width), y + 9, -14695425);
            }
        }

        @Override
        public int getItemHeight() {
            return 12;
        }

        @Override
        public int getWidth(EarlyGraphics graphics) {
            return graphics.width(this.text) + 10;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.contains && button == 0) {
                try {
                    ForkingUtils.openUrl(this.link);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    private static abstract class StringItem
    extends DynamicErrorFreeEntryListWidget.Entry<StringItem> {
        private StringItem() {
        }

        public abstract int getWidth(EarlyGraphics var1);
    }
}

