/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.vanilla;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.transform.TransformStack;
import net.minecraft.class_1058;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2480;
import net.minecraft.class_2627;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_7833;
import org.joml.Quaternionf;

public class ShulkerBoxInstance
extends BlockEntityInstance<class_2627>
implements DynamicInstance {
    private final class_1058 texture;
    private final ModelData base;
    private final ModelData lid;
    private final class_4587 stack = new class_4587();
    private float lastProgress = Float.NaN;

    public ShulkerBoxInstance(MaterialManager materialManager, class_2627 blockEntity) {
        super(materialManager, blockEntity);
        class_1767 color = blockEntity.method_11320();
        this.texture = color == null ? class_4722.field_21710.method_24148() : ((class_4730)class_4722.field_21711.get(color.method_7789())).method_24148();
        Quaternionf rotation = this.getDirection().method_23224();
        TransformStack tstack = TransformStack.cast(this.stack);
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)tstack.translate((class_2382)this.getInstancePosition())).scale(0.9995f)).translateAll(2.5E-4)).centre()).multiply(rotation)).unCentre();
        this.base = this.makeBaseInstance().setTransform(this.stack);
        tstack.translateY(0.25);
        this.lid = this.makeLidInstance().setTransform(this.stack);
    }

    @Override
    public void beginFrame() {
        float progress = ((class_2627)this.blockEntity).method_11312(AnimationTickHolder.getPartialTicks());
        if (progress == this.lastProgress) {
            return;
        }
        this.lastProgress = progress;
        Quaternionf spin = class_7833.field_40716.rotationDegrees(270.0f * progress);
        TransformStack tstack = TransformStack.cast(this.stack);
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)tstack.pushPose()).centre()).multiply(spin)).unCentre()).translateY(progress * 0.5f);
        this.lid.setTransform(this.stack);
        this.stack.method_22909();
    }

    @Override
    public void remove() {
        this.base.delete();
        this.lid.delete();
    }

    @Override
    public void updateLight() {
        this.relight(this.pos, this.base, this.lid);
    }

    private ModelData makeBaseInstance() {
        return this.materialManager.cutout(class_1921.method_23578((class_2960)class_4722.field_21704)).material(Materials.TRANSFORMED).model("base_" + this.texture.method_45851().method_45816(), this::makeBaseModel).createInstance();
    }

    private ModelData makeLidInstance() {
        return this.materialManager.cutout(class_1921.method_23578((class_2960)class_4722.field_21704)).material(Materials.TRANSFORMED).model("lid_" + this.texture.method_45851().method_45816(), this::makeLidModel).createInstance();
    }

    private ModelPart makeBaseModel() {
        return ModelPart.builder("shulker_base", 64, 64).sprite(this.texture).cuboid().textureOffset(0, 28).size(16.0f, 8.0f, 16.0f).invertYZ().endCuboid().build();
    }

    private ModelPart makeLidModel() {
        return ModelPart.builder("shulker_lid", 64, 64).sprite(this.texture).cuboid().size(16.0f, 12.0f, 16.0f).invertYZ().endCuboid().build();
    }

    private class_2350 getDirection() {
        if (this.blockState.method_26204() instanceof class_2480) {
            return (class_2350)this.blockState.method_11654((class_2769)class_2480.field_11496);
        }
        return class_2350.field_11036;
    }
}

