/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.vertex;

import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.core.layout.BufferLayout;
import com.jozufozu.flywheel.core.layout.CommonItems;
import com.jozufozu.flywheel.core.vertex.BlockVertexListUnsafe;
import com.jozufozu.flywheel.core.vertex.BlockWriterUnsafe;
import java.nio.ByteBuffer;

public class BlockVertex
implements VertexType {
    public static final BufferLayout FORMAT = BufferLayout.builder().addItems(CommonItems.VEC3, CommonItems.RGBA, CommonItems.UV, CommonItems.LIGHT_SHORT, CommonItems.NORMAL, CommonItems.PADDING_BYTE).build();

    @Override
    public BufferLayout getLayout() {
        return FORMAT;
    }

    @Override
    public BlockWriterUnsafe createWriter(ByteBuffer buffer) {
        return new BlockWriterUnsafe(this, buffer);
    }

    @Override
    public BlockVertexListUnsafe createReader(ByteBuffer buffer, int vertexCount) {
        return new BlockVertexListUnsafe(buffer, vertexCount);
    }

    public BlockVertexListUnsafe.Shaded createReader(ByteBuffer buffer, int vertexCount, int unshadedStartVertex) {
        return new BlockVertexListUnsafe.Shaded(buffer, vertexCount, unshadedStartVertex);
    }

    @Override
    public String getShaderHeader() {
        return "layout (location = 0) in vec3 _flw_v_pos;\nlayout (location = 1) in vec4 _flw_v_color;\nlayout (location = 2) in vec2 _flw_v_texCoords;\nlayout (location = 3) in vec2 _flw_v_light;\nlayout (location = 4) in vec3 _flw_v_normal;\n\nVertex FLWCreateVertex() {\n\tVertex v;\n\tv.pos = _flw_v_pos;\n\tv.color = _flw_v_color;\n\tv.texCoords = _flw_v_texCoords;\n\tv.light = _flw_v_light;\n\tv.normal = _flw_v_normal;\n\treturn v;\n}\n";
    }
}

