/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.source;

import com.google.common.collect.Lists;
import com.jozufozu.flywheel.core.source.Index;
import com.jozufozu.flywheel.core.source.SourceFile;
import com.jozufozu.flywheel.core.source.SourceFinder;
import com.jozufozu.flywheel.util.ResourceUtil;
import com.jozufozu.flywheel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class ShaderSources
implements SourceFinder {
    public static final String SHADER_DIR = "flywheel/shaders";
    public static final String SHADER_DIR_SLASH = "flywheel/shaders/";
    public static final ArrayList<String> EXTENSIONS = Lists.newArrayList((Object[])new String[]{".vert", ".vsh", ".frag", ".fsh", ".glsl"});
    private final Map<class_2960, SourceFile> shaderSources = new HashMap<class_2960, SourceFile>();
    public final Index index;

    public ShaderSources(class_3300 manager) {
        Map allShaders = manager.method_14488(SHADER_DIR, loc -> {
            String path = loc.method_12832();
            for (String ext : EXTENSIONS) {
                if (!path.endsWith(ext)) continue;
                return true;
            }
            return false;
        });
        allShaders.forEach((location, resource) -> {
            try (InputStream inputStream = resource.method_14482();){
                String source = StringUtil.readToString(inputStream);
                class_2960 name = ResourceUtil.removePrefixUnchecked(location, SHADER_DIR_SLASH);
                this.shaderSources.put(name, new SourceFile(this, name, source));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.index = new Index(this.shaderSources);
    }

    @Override
    @Nullable
    public SourceFile findSource(class_2960 name) {
        return this.shaderSources.get(name);
    }
}

