/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.source;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.source.SourceFile;
import com.jozufozu.flywheel.core.source.SourceFinder;
import com.jozufozu.flywheel.core.source.error.ErrorBuilder;
import com.jozufozu.flywheel.core.source.span.Span;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2960;

public class FileResolution {
    private final List<Consumer<ErrorBuilder>> extraCrashInfoProviders = new ArrayList<Consumer<ErrorBuilder>>();
    private final class_2960 fileLoc;
    private SourceFile file;

    FileResolution(class_2960 fileLoc) {
        this.fileLoc = fileLoc;
    }

    public class_2960 getFileLoc() {
        return this.fileLoc;
    }

    public SourceFile getFile() {
        return this.file;
    }

    public FileResolution addSpan(Span span) {
        this.extraCrashInfoProviders.add(builder -> builder.pointAtFile(span.getSourceFile()).pointAt(span, 1));
        return this;
    }

    public void addSpec(class_2960 name) {
        this.extraCrashInfoProviders.add(builder -> builder.extra("needed by spec: " + name + ".json"));
    }

    boolean resolve(SourceFinder sources) {
        this.file = sources.findSource(this.fileLoc);
        if (this.file == null) {
            ErrorBuilder builder = ErrorBuilder.error(String.format("could not find source for file %s", this.fileLoc));
            for (Consumer<ErrorBuilder> consumer : this.extraCrashInfoProviders) {
                consumer.accept(builder);
            }
            Backend.LOGGER.error(builder.build());
            return false;
        }
        this.extraCrashInfoProviders.clear();
        return true;
    }

    void invalidate() {
        this.extraCrashInfoProviders.clear();
        this.file = null;
    }
}

