/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.util.FlwUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.minecraft.class_287;
import org.lwjgl.system.MemoryUtil;

public interface ShadeSeparatedBufferedData {
    public ByteBuffer vertexBuffer();

    public ByteBuffer indexBuffer();

    public class_287.class_4574 drawState();

    public int unshadedStartVertex();

    public void release();

    public static final class NativeImpl
    implements ShadeSeparatedBufferedData {
        private final ByteBuffer vertexBuffer;
        private final ByteBuffer indexBuffer;
        private final class_287.class_4574 drawState;
        private final int unshadedStartVertex;

        public NativeImpl(ByteBuffer vertexBuffer, ByteBuffer indexBuffer, class_287.class_4574 drawState, int unshadedStartVertex) {
            this.vertexBuffer = FlwUtil.copyBuffer(vertexBuffer);
            this.indexBuffer = FlwUtil.copyBuffer(indexBuffer);
            this.drawState = drawState;
            this.unshadedStartVertex = unshadedStartVertex;
        }

        @Override
        public ByteBuffer vertexBuffer() {
            return this.vertexBuffer;
        }

        @Override
        public ByteBuffer indexBuffer() {
            return this.indexBuffer;
        }

        @Override
        public class_287.class_4574 drawState() {
            return this.drawState;
        }

        @Override
        public int unshadedStartVertex() {
            return this.unshadedStartVertex;
        }

        @Override
        public void release() {
            MemoryUtil.memFree((Buffer)this.vertexBuffer);
            MemoryUtil.memFree((Buffer)this.indexBuffer);
        }
    }
}

