/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.api.vertex.ShadedVertexList;
import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.core.model.Model;
import com.jozufozu.flywheel.util.DiffuseLightCalculator;
import com.jozufozu.flywheel.util.transform.Transform;
import java.util.function.IntPredicate;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ModelTransformer {
    private final Model model;
    private final VertexList reader;
    private final IntPredicate shadedPredicate;
    public final Context context = new Context();

    public ModelTransformer(Model model) {
        this.model = model;
        VertexList vertexList = this.reader = model.getReader();
        if (vertexList instanceof ShadedVertexList) {
            ShadedVertexList shaded = (ShadedVertexList)vertexList;
            this.shadedPredicate = shaded::isShaded;
        } else {
            this.shadedPredicate = index -> true;
        }
    }

    public void renderInto(Params params, class_4587 input, class_4588 builder) {
        Matrix3f normalMat;
        if (this.isEmpty()) {
            return;
        }
        Vector4f pos = new Vector4f();
        Vector3f normal = new Vector3f();
        Matrix4f modelMat = new Matrix4f((Matrix4fc)input.method_23760().method_23761());
        modelMat.mul((Matrix4fc)params.model);
        if (this.context.fullNormalTransform) {
            normalMat = new Matrix3f((Matrix3fc)input.method_23760().method_23762());
            normalMat.mul((Matrix3fc)params.normal);
        } else {
            normalMat = new Matrix3f((Matrix3fc)params.normal);
        }
        DiffuseLightCalculator diffuseCalculator = DiffuseLightCalculator.forCurrentLevel();
        int vertexCount = this.reader.getVertexCount();
        for (int i = 0; i < vertexCount; ++i) {
            byte a;
            byte b;
            byte g;
            byte r;
            float x = this.reader.getX(i);
            float y = this.reader.getY(i);
            float z = this.reader.getZ(i);
            pos.set(x, y, z, 1.0f);
            pos.mul((Matrix4fc)modelMat);
            builder.method_22912((double)pos.x(), (double)pos.y(), (double)pos.z());
            float normalX = this.reader.getNX(i);
            float normalY = this.reader.getNY(i);
            float normalZ = this.reader.getNZ(i);
            normal.set(normalX, normalY, normalZ);
            normal.mul((Matrix3fc)normalMat);
            normal.normalize();
            float nx = normal.x();
            float ny = normal.y();
            float nz = normal.z();
            if (params.useParamColor) {
                r = (byte)params.r;
                g = (byte)params.g;
                b = (byte)params.b;
                a = (byte)params.a;
            } else {
                r = this.reader.getR(i);
                g = this.reader.getG(i);
                b = this.reader.getB(i);
                a = this.reader.getA(i);
            }
            if (this.context.outputColorDiffuse) {
                float instanceDiffuse = diffuseCalculator.getDiffuse(nx, ny, nz, this.shadedPredicate.test(i));
                int colorR = ModelTransformer.transformColor(r, instanceDiffuse);
                int colorG = ModelTransformer.transformColor(g, instanceDiffuse);
                int colorB = ModelTransformer.transformColor(b, instanceDiffuse);
                builder.method_1336(colorR, colorG, colorB, (int)a);
            } else {
                builder.method_1336((int)r, (int)g, (int)b, (int)a);
            }
            float u = this.reader.getU(i);
            float v = this.reader.getV(i);
            if (params.spriteShiftFunc != null) {
                params.spriteShiftFunc.shift(builder, u, v);
            } else {
                builder.method_22913(u, v);
            }
            builder.method_22922(params.overlay);
            builder.method_22916(params.useParamLight ? params.packedLightCoords : this.reader.getLight(i));
            builder.method_22914(nx, ny, nz);
            builder.method_1344();
        }
    }

    public boolean isEmpty() {
        return this.reader.isEmpty();
    }

    public String toString() {
        return "ModelTransformer[" + this.model + "]";
    }

    public static int transformColor(byte component, float scale) {
        return class_3532.method_15340((int)((int)((float)Byte.toUnsignedInt(component) * scale)), (int)0, (int)255);
    }

    public static int transformColor(int component, float scale) {
        return class_3532.method_15340((int)((int)((float)component * scale)), (int)0, (int)255);
    }

    public static class Context {
        public boolean fullNormalTransform = false;
        public boolean outputColorDiffuse = true;
    }

    public static class Params
    implements Transform<Params> {
        public final Matrix4f model = new Matrix4f();
        public final Matrix3f normal = new Matrix3f();
        public boolean useParamColor;
        public int r;
        public int g;
        public int b;
        public int a;
        public SpriteShiftFunc spriteShiftFunc;
        public int overlay;
        public boolean useParamLight;
        public int packedLightCoords;

        public void loadDefault() {
            this.model.identity();
            this.normal.identity();
            this.useParamColor = true;
            this.r = 255;
            this.g = 255;
            this.b = 255;
            this.a = 255;
            this.spriteShiftFunc = null;
            this.overlay = class_4608.field_21444;
            this.useParamLight = false;
            this.packedLightCoords = 0xF000F0;
        }

        public void load(Params from) {
            this.model.set((Matrix4fc)from.model);
            this.normal.set((Matrix3fc)from.normal);
            this.useParamColor = from.useParamColor;
            this.r = from.r;
            this.g = from.g;
            this.b = from.b;
            this.a = from.a;
            this.spriteShiftFunc = from.spriteShiftFunc;
            this.overlay = from.overlay;
            this.useParamLight = from.useParamLight;
            this.packedLightCoords = from.packedLightCoords;
        }

        public Params color(int r, int g, int b, int a) {
            this.useParamColor = true;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            return this;
        }

        public Params color(byte r, byte g, byte b, byte a) {
            this.useParamColor = true;
            this.r = Byte.toUnsignedInt(r);
            this.g = Byte.toUnsignedInt(g);
            this.b = Byte.toUnsignedInt(b);
            this.a = Byte.toUnsignedInt(a);
            return this;
        }

        public Params color(int color) {
            this.useParamColor = true;
            this.r = color >> 16 & 0xFF;
            this.g = color >> 8 & 0xFF;
            this.b = color & 0xFF;
            this.a = 255;
            return this;
        }

        public Params shiftUV(SpriteShiftFunc entry) {
            this.spriteShiftFunc = entry;
            return this;
        }

        public Params overlay(int overlay) {
            this.overlay = overlay;
            return this;
        }

        public Params light(int packedLightCoords) {
            this.useParamLight = true;
            this.packedLightCoords = packedLightCoords;
            return this;
        }

        @Override
        public Params multiply(Quaternionf quaternion) {
            this.model.rotate((Quaternionfc)quaternion);
            this.normal.rotate((Quaternionfc)quaternion);
            return this;
        }

        @Override
        public Params scale(float pX, float pY, float pZ) {
            this.model.scale(pX, pY, pZ);
            if (pX == pY && pY == pZ) {
                if (pX > 0.0f) {
                    return this;
                }
                this.normal.scale(-1.0f);
            }
            float f = 1.0f / pX;
            float f1 = 1.0f / pY;
            float f2 = 1.0f / pZ;
            float f3 = class_3532.method_23278((float)(f * f1 * f2));
            this.normal.scale(f3 * f, f3 * f1, f3 * f2);
            return this;
        }

        @Override
        public Params translate(double x, double y, double z) {
            this.model.translate((float)x, (float)y, (float)z);
            return this;
        }

        @Override
        public Params mulPose(Matrix4f pose) {
            this.model.mul((Matrix4fc)pose);
            return this;
        }

        @Override
        public Params mulNormal(Matrix3f normal) {
            this.normal.mul((Matrix3fc)normal);
            return this;
        }
    }

    @FunctionalInterface
    public static interface SpriteShiftFunc {
        public void shift(class_4588 var1, float var2, float var3);
    }
}

