/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferUsage;
import com.jozufozu.flywheel.backend.model.ElementBuffer;
import com.jozufozu.flywheel.core.Formats;
import com.jozufozu.flywheel.core.QuadConverter;
import com.jozufozu.flywheel.core.model.Bufferable;
import com.jozufozu.flywheel.core.model.Model;
import com.jozufozu.flywheel.core.model.ModelUtil;
import com.jozufozu.flywheel.core.model.ShadeSeparatedBufferedData;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.class_1087;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_311;
import net.minecraft.class_4587;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.MemoryUtil;

public class BlockModel
implements Model {
    private final VertexList reader;
    private final String name;
    private final EBOSupplier eboSupplier;

    public BlockModel(ByteBuffer vertexBuffer, ByteBuffer indexBuffer, class_287.class_4574 drawState, int unshadedStartVertex, String name) {
        if (drawState.comp_749() != class_290.field_1590) {
            throw new RuntimeException("Cannot use buffered data with non-block format '" + drawState.comp_749() + "'");
        }
        this.reader = Formats.BLOCK.createReader(vertexBuffer, drawState.comp_750(), unshadedStartVertex);
        this.name = name;
        this.eboSupplier = !drawState.comp_755() ? new BufferEBOSupplier(indexBuffer, drawState.comp_751(), drawState.comp_753()) : () -> QuadConverter.getInstance().quads2Tris(this.vertexCount() / 4);
    }

    public BlockModel(ByteBuffer vertexBuffer, ByteBuffer indexBuffer, class_287.class_4574 drawState, String name) {
        if (drawState.comp_749() != class_290.field_1590) {
            throw new RuntimeException("Cannot use buffered data with non-block format '" + drawState.comp_749() + "'");
        }
        this.reader = Formats.BLOCK.createReader(vertexBuffer, drawState.comp_750());
        this.name = name;
        this.eboSupplier = !drawState.comp_755() ? new BufferEBOSupplier(indexBuffer, drawState.comp_751(), drawState.comp_753()) : () -> QuadConverter.getInstance().quads2Tris(this.vertexCount() / 4);
    }

    public BlockModel(ShadeSeparatedBufferedData data, String name) {
        this(data.vertexBuffer(), data.indexBuffer(), data.drawState(), data.unshadedStartVertex(), name);
    }

    public static BlockModel of(Bufferable bufferable, String name) {
        ShadeSeparatedBufferedData data = bufferable.build();
        BlockModel model = new BlockModel(data, name);
        data.release();
        return model;
    }

    public static BlockModel of(class_1087 model, class_2680 referenceState) {
        ShadeSeparatedBufferedData data = ModelUtil.getBufferedData(model, referenceState);
        BlockModel blockModel = new BlockModel(data, referenceState.toString());
        data.release();
        return blockModel;
    }

    public static BlockModel of(class_2680 state) {
        return BlockModel.of(class_310.method_1551().method_1541().method_3349(state), state);
    }

    public static BlockModel of(class_1087 model, class_2680 referenceState, class_4587 ms) {
        ShadeSeparatedBufferedData data = ModelUtil.getBufferedData(model, referenceState, ms);
        BlockModel blockModel = new BlockModel(data, referenceState.toString());
        data.release();
        return blockModel;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int vertexCount() {
        return this.reader.getVertexCount();
    }

    @Override
    public VertexList getReader() {
        return this.reader;
    }

    @Override
    public ElementBuffer createEBO() {
        return (ElementBuffer)this.eboSupplier.get();
    }

    @Override
    public VertexType getType() {
        return Formats.BLOCK;
    }

    @Override
    public void delete() {
        this.reader.delete();
        this.eboSupplier.delete();
    }

    private static class BufferEBOSupplier
    implements EBOSupplier {
        private final ByteBuffer indexBuffer;
        private final int indexCount;
        private final class_293.class_5595 indexType;
        private int eboName = -1;
        private ElementBuffer ebo;

        public BufferEBOSupplier(ByteBuffer indexBufferSrc, int indexCount, class_293.class_5595 indexType) {
            this.indexBuffer = class_311.method_1596((int)indexBufferSrc.capacity());
            MemoryUtil.memCopy((ByteBuffer)indexBufferSrc, (ByteBuffer)this.indexBuffer);
            this.indexCount = indexCount;
            this.indexType = indexType;
        }

        @Override
        public ElementBuffer get() {
            if (this.eboName == -1) {
                this.eboName = this.createEBO();
                this.ebo = new ElementBuffer(this.eboName, this.indexCount, this.indexType);
                MemoryUtil.memFree((Buffer)this.indexBuffer);
            }
            return this.ebo;
        }

        private int createEBO() {
            int vbo = GL32.glGenBuffers();
            GlBufferType bufferType = GlBufferType.ARRAY_BUFFER;
            int oldBuffer = bufferType.getBoundBuffer();
            bufferType.bind(vbo);
            GL15.glBufferData((int)bufferType.glEnum, (ByteBuffer)this.indexBuffer, (int)GlBufferUsage.STATIC_DRAW.glEnum);
            bufferType.bind(oldBuffer);
            return vbo;
        }

        @Override
        public void delete() {
            GL32.glDeleteBuffers((int)this.eboName);
        }
    }

    private static interface EBOSupplier
    extends Supplier<ElementBuffer> {
        default public void delete() {
        }
    }
}

