/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.layout;

import com.jozufozu.flywheel.backend.gl.GlNumericType;
import com.jozufozu.flywheel.core.layout.LayoutItem;
import org.lwjgl.opengl.GL20;

public class PrimitiveItem
implements LayoutItem {
    private final GlNumericType type;
    private final int count;
    private final int size;
    private final int attributeCount;
    private final boolean normalized;

    public PrimitiveItem(GlNumericType type, int count) {
        this(type, count, false);
    }

    public PrimitiveItem(GlNumericType type, int count, boolean normalized) {
        this.type = type;
        this.count = count;
        this.size = type.getByteWidth() * count;
        this.attributeCount = (this.size + 15) / 16;
        this.normalized = normalized;
    }

    @Override
    public void vertexAttribPointer(int stride, int index, int offset) {
        GL20.glVertexAttribPointer((int)index, (int)this.count, (int)this.type.getGlEnum(), (boolean)this.normalized, (int)stride, (long)offset);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int attributeCount() {
        return this.attributeCount;
    }
}

