/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.crumbling;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlStateTracker;
import com.jozufozu.flywheel.backend.instancing.InstanceManager;
import com.jozufozu.flywheel.backend.instancing.SerialTaskEngine;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.core.Contexts;
import com.jozufozu.flywheel.core.crumbling.CrumblingGroup;
import com.jozufozu.flywheel.core.crumbling.CrumblingInstanceManager;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.mixin.LevelRendererAccessor;
import com.jozufozu.flywheel.util.Lazy;
import com.jozufozu.flywheel.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import net.minecraft.class_1088;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class CrumblingRenderer {
    static class_1921 _currentLayer;
    private static final Lazy<State> STATE;
    private static final Lazy.KillSwitch<State> INVALIDATOR;

    public static void render(class_638 level, class_4184 camera, class_4587 stack) {
        if (!Backend.canUseInstancing((class_1937)level)) {
            return;
        }
        Int2ObjectMap<List<class_2586>> activeStages = CrumblingRenderer.getActiveStageBlockEntities(level);
        if (activeStages.isEmpty()) {
            return;
        }
        class_243 cameraPos = camera.method_19326();
        GlStateTracker.State restoreState = GlStateTracker.getRestoreState();
        CrumblingRenderer.renderCrumbling(activeStages, camera, new RenderLayerEvent(level, null, stack, null, cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350));
        restoreState.restore();
    }

    private static void renderCrumbling(Int2ObjectMap<List<class_2586>> activeStages, class_4184 camera, RenderLayerEvent event) {
        State state = STATE.get();
        InstanceManager<class_2586> instanceManager = state.instanceManager;
        InstancingEngine<WorldProgram> materials = state.materialManager;
        for (Int2ObjectMap.Entry stage : activeStages.int2ObjectEntrySet()) {
            _currentLayer = (class_1921)class_1088.field_21772.get(stage.getIntKey());
            if (_currentLayer == null) continue;
            ((List)stage.getValue()).forEach(instanceManager::add);
            instanceManager.beginFrame(SerialTaskEngine.INSTANCE, camera);
            materials.render(SerialTaskEngine.INSTANCE, event);
            instanceManager.invalidate();
        }
    }

    private static Int2ObjectMap<List<class_2586>> getActiveStageBlockEntities(class_638 world) {
        Int2ObjectArrayMap breakingEntities = new Int2ObjectArrayMap();
        for (Long2ObjectMap.Entry entry : ((LevelRendererAccessor)class_310.method_1551().field_1769).flywheel$getDestructionProgress().long2ObjectEntrySet()) {
            class_2338 breakingPos = class_2338.method_10092((long)entry.getLongKey());
            SortedSet progresses = (SortedSet)entry.getValue();
            if (progresses == null || progresses.isEmpty()) continue;
            int blockDamage = ((class_3191)progresses.last()).method_13988();
            class_2586 blockEntity = world.method_8321(breakingPos);
            if (blockEntity == null) continue;
            List blockEntities = (List)breakingEntities.computeIfAbsent(blockDamage, $ -> new ArrayList());
            blockEntities.add(blockEntity);
        }
        return breakingEntities;
    }

    public static void onReloadRenderers(ReloadRenderersEvent event) {
        class_638 world = event.getWorld();
        if (Backend.isOn() && world != null) {
            CrumblingRenderer.reset();
        }
    }

    public static void reset() {
        INVALIDATOR.killValue();
    }

    static {
        Pair<Lazy<State>, Lazy.KillSwitch<State>> state = Lazy.ofKillable(State::new, State::kill);
        STATE = state.first();
        INVALIDATOR = state.second();
    }

    private static class State {
        private final InstancingEngine<WorldProgram> materialManager = InstancingEngine.builder(Contexts.CRUMBLING).setGroupFactory(CrumblingGroup::new).build();
        private final InstanceManager<class_2586> instanceManager = new CrumblingInstanceManager(this.materialManager);

        private State() {
            this.materialManager.addListener(this.instanceManager);
        }

        private void kill() {
            this.materialManager.delete();
            this.instanceManager.invalidate();
        }
    }
}

