/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core;

import com.jozufozu.flywheel.backend.gl.GlNumericType;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferUsage;
import com.jozufozu.flywheel.backend.model.ElementBuffer;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import net.minecraft.class_293;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryUtil;

public class QuadConverter {
    private static QuadConverter INSTANCE;
    private final Int2ReferenceMap<ElementBuffer> cache = new Int2ReferenceArrayMap();
    private final int ebo = GL32.glGenBuffers();
    private int quadCapacity = 0;

    @NotNull
    public static QuadConverter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new QuadConverter();
        }
        return INSTANCE;
    }

    @Nullable
    public static QuadConverter getNullable() {
        return INSTANCE;
    }

    public ElementBuffer quads2Tris(int quads) {
        if (quads > this.quadCapacity) {
            this.grow(quads * 2);
        }
        return (ElementBuffer)this.cache.computeIfAbsent(quads, this::createElementBuffer);
    }

    @NotNull
    private ElementBuffer createElementBuffer(int quads) {
        return new ElementBuffer(this.ebo, quads * 6, class_293.class_5595.field_27373);
    }

    private void grow(int quads) {
        int byteSize = quads * 6 * GlNumericType.UINT.getByteWidth();
        long ptr = MemoryUtil.nmemAlloc((long)byteSize);
        this.fillBuffer(ptr, quads);
        GlBufferType bufferType = GlBufferType.ARRAY_BUFFER;
        int oldBuffer = bufferType.getBoundBuffer();
        bufferType.bind(this.ebo);
        GL32C.nglBufferData((int)bufferType.glEnum, (long)byteSize, (long)ptr, (int)GlBufferUsage.STATIC_DRAW.glEnum);
        bufferType.bind(oldBuffer);
        MemoryUtil.nmemFree((long)ptr);
        this.quadCapacity = quads;
    }

    public void delete() {
        GL32.glDeleteBuffers((int)this.ebo);
        this.cache.clear();
        this.quadCapacity = 0;
    }

    private void fillBuffer(long ptr, int quads) {
        int numVertices = 4 * quads;
        int baseVertex = 0;
        while (baseVertex < numVertices) {
            this.writeQuadIndicesUnsafe(ptr, baseVertex);
            baseVertex += 4;
            ptr += 24L;
        }
    }

    private void writeQuadIndicesUnsafe(long ptr, int baseVertex) {
        MemoryUtil.memPutInt((long)ptr, (int)baseVertex);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)(baseVertex + 1));
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)(baseVertex + 2));
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)baseVertex);
        MemoryUtil.memPutInt((long)(ptr + 16L), (int)(baseVertex + 2));
        MemoryUtil.memPutInt((long)(ptr + 20L), (int)(baseVertex + 3));
    }

    public static void onRendererReload(ReloadRenderersEvent event) {
        if (INSTANCE != null) {
            INSTANCE.delete();
            INSTANCE = null;
        }
    }
}

