/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.entity;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.AbstractInstance;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.light.TickingLightListener;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.joml.Vector3f;

public abstract class EntityInstance<E extends class_1297>
extends AbstractInstance
implements LightListener,
TickingLightListener {
    protected final E entity;
    protected final GridAlignedBB bounds;

    public EntityInstance(MaterialManager materialManager, E entity) {
        super(materialManager, entity.method_37908());
        this.entity = entity;
        this.bounds = GridAlignedBB.from(entity.method_5829());
    }

    @Override
    public GridAlignedBB getVolume() {
        return this.bounds;
    }

    @Override
    public boolean tickLightListener() {
        class_238 boundsNow = this.entity.method_5829();
        if (this.bounds.sameAs(boundsNow)) {
            return false;
        }
        this.bounds.assign(boundsNow);
        this.updateLight();
        return true;
    }

    public Vector3f getInstancePosition() {
        class_243 pos = this.entity.method_19538();
        class_2382 origin = this.materialManager.getOriginCoordinate();
        return new Vector3f((float)(pos.field_1352 - (double)origin.method_10263()), (float)(pos.field_1351 - (double)origin.method_10264()), (float)(pos.field_1350 - (double)origin.method_10260()));
    }

    public Vector3f getInstancePosition(float partialTicks) {
        class_243 pos = this.entity.method_19538();
        class_2382 origin = this.materialManager.getOriginCoordinate();
        return new Vector3f((float)(class_3532.method_16436((double)partialTicks, (double)((class_1297)this.entity).field_6038, (double)pos.field_1352) - (double)origin.method_10263()), (float)(class_3532.method_16436((double)partialTicks, (double)((class_1297)this.entity).field_5971, (double)pos.field_1351) - (double)origin.method_10264()), (float)(class_3532.method_16436((double)partialTicks, (double)((class_1297)this.entity).field_5989, (double)pos.field_1350) - (double)origin.method_10260()));
    }

    @Override
    public class_2338 getWorldPosition() {
        return this.entity.method_24515();
    }
}

