/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.batching;

import com.jozufozu.flywheel.api.MaterialGroup;
import com.jozufozu.flywheel.backend.RenderLayer;
import com.jozufozu.flywheel.backend.instancing.BatchDrawingTracker;
import com.jozufozu.flywheel.backend.instancing.Engine;
import com.jozufozu.flywheel.backend.instancing.TaskEngine;
import com.jozufozu.flywheel.backend.instancing.batching.BatchedMaterialGroup;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.util.FlwUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_308;
import net.minecraft.class_4184;
import org.joml.Matrix4f;

public class BatchingEngine
implements Engine {
    private final Map<RenderLayer, Map<class_1921, BatchedMaterialGroup>> layers;
    private final BatchDrawingTracker batchTracker = new BatchDrawingTracker();

    public BatchingEngine() {
        this.layers = new EnumMap<RenderLayer, Map<class_1921, BatchedMaterialGroup>>(RenderLayer.class);
        for (RenderLayer value : RenderLayer.values()) {
            this.layers.put(value, new HashMap());
        }
    }

    @Override
    public MaterialGroup state(RenderLayer layer, class_1921 state) {
        return this.layers.get((Object)layer).computeIfAbsent(state, BatchedMaterialGroup::new);
    }

    @Override
    public class_2382 getOriginCoordinate() {
        return class_2338.field_10980;
    }

    @Override
    public void render(TaskEngine taskEngine, RenderLayerEvent event) {
        Map<class_1921, BatchedMaterialGroup> groups = this.layers.get((Object)event.getLayer());
        for (BatchedMaterialGroup group : groups.values()) {
            group.render(event.stack, this.batchTracker, taskEngine);
        }
        Matrix4f mat = new Matrix4f();
        if (event.getWorld().method_28103().method_29993()) {
            class_308.method_1452((Matrix4f)mat);
        } else {
            class_308.method_27869((Matrix4f)mat);
        }
        taskEngine.syncPoint();
        this.batchTracker.endBatch();
    }

    @Override
    public void delete() {
        for (Map<class_1921, BatchedMaterialGroup> groups : this.layers.values()) {
            groups.values().forEach(BatchedMaterialGroup::delete);
        }
    }

    @Override
    public void beginFrame(class_4184 info) {
    }

    @Override
    public void addDebugInfo(List<String> info) {
        info.add("Batching");
        info.add("Instances: " + this.layers.values().stream().flatMap(FlwUtil::mapValues).mapToInt(BatchedMaterialGroup::getInstanceCount).sum());
        info.add("Vertices: " + this.layers.values().stream().flatMap(FlwUtil::mapValues).mapToInt(BatchedMaterialGroup::getVertexCount).sum());
    }
}

