/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.batching;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialGroup;
import com.jozufozu.flywheel.api.struct.Batched;
import com.jozufozu.flywheel.api.struct.StructType;
import com.jozufozu.flywheel.backend.ShadersModHandler;
import com.jozufozu.flywheel.backend.instancing.BatchDrawingTracker;
import com.jozufozu.flywheel.backend.instancing.TaskEngine;
import com.jozufozu.flywheel.backend.instancing.batching.BatchedMaterial;
import com.jozufozu.flywheel.backend.instancing.batching.CPUInstancer;
import com.jozufozu.flywheel.backend.model.DirectVertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_4587;

public class BatchedMaterialGroup
implements MaterialGroup {
    protected final class_1921 state;
    private final Map<Batched<? extends InstanceData>, BatchedMaterial<?>> materials = new HashMap();
    private int vertexCount;
    private int instanceCount;

    public BatchedMaterialGroup(class_1921 state) {
        this.state = state;
    }

    public <D extends InstanceData> BatchedMaterial<D> material(StructType<D> type) {
        if (type instanceof Batched) {
            Batched batched = (Batched)type;
            return this.materials.computeIfAbsent(batched, BatchedMaterial::new);
        }
        throw new ClassCastException("Cannot use type '" + type + "' with CPU instancing.");
    }

    public void render(class_4587 stack, BatchDrawingTracker source, TaskEngine pool) {
        this.vertexCount = 0;
        this.instanceCount = 0;
        for (BatchedMaterial<?> material : this.materials.values()) {
            for (CPUInstancer instancer : material.models.values()) {
                instancer.setup();
                this.vertexCount += instancer.getVertexCount();
                this.instanceCount += instancer.getInstanceCount();
            }
        }
        DirectVertexConsumer consumer = source.getDirectConsumer(this.state, this.vertexCount);
        consumer.memSetZero();
        for (BatchedMaterial<?> material : this.materials.values()) {
            for (CPUInstancer instancer : material.models.values()) {
                instancer.sbb.context.outputColorDiffuse = !consumer.hasOverlay() && !ShadersModHandler.isShaderPackInUse();
                instancer.submitTasks(stack, pool, consumer);
            }
        }
    }

    public void clear() {
        this.materials.values().forEach(BatchedMaterial::clear);
    }

    public void delete() {
        this.materials.values().forEach(BatchedMaterial::delete);
        this.materials.clear();
    }

    public int getInstanceCount() {
        return this.instanceCount;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }
}

