/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.Flywheel;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstanceManager;
import com.jozufozu.flywheel.backend.instancing.InstanceWorld;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.config.FlwCommands;
import com.jozufozu.flywheel.config.FlwConfig;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.WorldAttached;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class InstancedRenderDispatcher {
    private static final WorldAttached<InstanceWorld> instanceWorlds = new WorldAttached<InstanceWorld>(InstanceWorld::create);

    public static void enqueueUpdate(class_2586 blockEntity) {
        if (Backend.isOn() && blockEntity.method_11002() && blockEntity.method_10997() instanceof class_638) {
            instanceWorlds.get((class_1936)blockEntity.method_10997()).getBlockEntityInstanceManager().queueUpdate(blockEntity);
        }
    }

    public static void enqueueUpdate(class_1297 entity) {
        if (Backend.isOn()) {
            instanceWorlds.get((class_1936)entity.method_37908()).getEntityInstanceManager().queueUpdate(entity);
        }
    }

    public static InstanceManager<class_2586> getBlockEntities(class_1936 world) {
        return InstancedRenderDispatcher.getInstanceWorld(world).getBlockEntityInstanceManager();
    }

    public static InstanceManager<class_1297> getEntities(class_1936 world) {
        return InstancedRenderDispatcher.getInstanceWorld(world).getEntityInstanceManager();
    }

    public static InstanceWorld getInstanceWorld(class_1936 world) {
        if (Backend.isOn()) {
            return instanceWorlds.get(world);
        }
        throw new NullPointerException("Backend is off, cannot retrieve instance world.");
    }

    public static void tick(class_310 mc) {
        if (!Backend.isGameActive()) {
            return;
        }
        class_638 world = mc.field_1687;
        AnimationTickHolder.tick();
        if (Backend.isOn()) {
            instanceWorlds.get((class_1936)world).tick();
        }
    }

    public static void onBeginFrame(BeginFrameEvent event) {
        if (Backend.isGameActive() && Backend.isOn()) {
            instanceWorlds.get((class_1936)event.getWorld()).beginFrame(event);
        }
    }

    public static void renderLayer(RenderLayerEvent event) {
        if (event.layer == null) {
            return;
        }
        class_638 world = event.getWorld();
        if (!Backend.canUseInstancing((class_1937)world)) {
            return;
        }
        instanceWorlds.get((class_1936)world).renderLayer(event);
    }

    public static void onReloadRenderers(ReloadRenderersEvent event) {
        class_638 world = event.getWorld();
        if (Backend.isOn() && world != null) {
            InstancedRenderDispatcher.resetInstanceWorld(world);
        }
    }

    public static void resetInstanceWorld(class_638 world) {
        instanceWorlds.replace((class_1936)world, InstanceWorld::delete).loadEntities(world);
    }

    public static <T extends class_2586> boolean tryAddBlockEntity(T blockEntity) {
        class_1937 level = blockEntity.method_10997();
        if (!Backend.canUseInstancing(level)) {
            return false;
        }
        if (!InstancedRenderRegistry.canInstance(blockEntity.method_11017())) {
            return false;
        }
        InstancedRenderDispatcher.getBlockEntities((class_1936)level).queueAdd(blockEntity);
        return InstancedRenderRegistry.shouldSkipRender(blockEntity);
    }

    public static void getDebugString(List<String> debug) {
        debug.add("");
        debug.add("Flywheel: " + Flywheel.getVersion());
        if (Backend.isOn()) {
            InstanceWorld instanceWorld = instanceWorlds.get((class_1936)class_310.method_1551().field_1687);
            debug.add("Update limiting: " + FlwCommands.boolToText(FlwConfig.get().limitUpdates()).getString());
            debug.add("B: " + instanceWorld.blockEntityInstanceManager.getObjectCount() + ", E: " + instanceWorld.entityInstanceManager.getObjectCount());
            instanceWorld.engine.addDebugInfo(debug);
        } else {
            debug.add("Disabled");
        }
    }
}

