/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.api.instance.Instance;
import com.jozufozu.flywheel.api.instance.TickableInstance;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.AbstractInstance;
import com.jozufozu.flywheel.backend.instancing.TaskEngine;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.backend.instancing.ratelimit.BandedPrimeLimiter;
import com.jozufozu.flywheel.backend.instancing.ratelimit.DistanceUpdateLimiter;
import com.jozufozu.flywheel.backend.instancing.ratelimit.NonLimiter;
import com.jozufozu.flywheel.config.FlwConfig;
import com.jozufozu.flywheel.light.LightUpdater;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_4184;
import org.joml.Vector3f;

public abstract class InstanceManager<T>
implements InstancingEngine.OriginShiftListener {
    public final MaterialManager materialManager;
    private final Set<T> queuedAdditions;
    private final Set<T> queuedUpdates;
    protected final Map<T, AbstractInstance> instances;
    protected final Object2ObjectOpenHashMap<T, TickableInstance> tickableInstances;
    protected final Object2ObjectOpenHashMap<T, DynamicInstance> dynamicInstances;
    protected DistanceUpdateLimiter frame;
    protected DistanceUpdateLimiter tick;

    public InstanceManager(MaterialManager materialManager) {
        this.materialManager = materialManager;
        this.queuedUpdates = new HashSet<T>(64);
        this.queuedAdditions = new HashSet<T>(64);
        this.instances = new HashMap<T, AbstractInstance>();
        this.dynamicInstances = new Object2ObjectOpenHashMap();
        this.tickableInstances = new Object2ObjectOpenHashMap();
        this.frame = this.createUpdateLimiter();
        this.tick = this.createUpdateLimiter();
    }

    protected DistanceUpdateLimiter createUpdateLimiter() {
        if (FlwConfig.get().limitUpdates()) {
            return new BandedPrimeLimiter();
        }
        return new NonLimiter();
    }

    public int getObjectCount() {
        return this.instances.size();
    }

    protected abstract boolean canInstance(T var1);

    protected abstract boolean canCreateInstance(T var1);

    @Nullable
    protected abstract AbstractInstance createRaw(T var1);

    public void tick(TaskEngine taskEngine, double cameraX, double cameraY, double cameraZ) {
        this.tick.tick();
        this.processQueuedUpdates();
        int cX = (int)cameraX;
        int cY = (int)cameraY;
        int cZ = (int)cameraZ;
        ArrayList instances = new ArrayList(this.tickableInstances.values());
        int incr = 500;
        int size = instances.size();
        for (int start = 0; start < size; start += incr) {
            int end = Math.min(start + incr, size);
            List sub = instances.subList(start, end);
            taskEngine.submit(() -> {
                for (TickableInstance instance : sub) {
                    this.tickInstance(cX, cY, cZ, instance);
                }
            });
        }
    }

    protected void tickInstance(int cX, int cY, int cZ, TickableInstance instance) {
        int dZ;
        int dY;
        if (!instance.decreaseTickRateWithDistance()) {
            instance.tick();
            return;
        }
        class_2338 pos = instance.getWorldPosition();
        int dX = pos.method_10263() - cX;
        if (this.tick.shouldUpdate(dX, dY = pos.method_10264() - cY, dZ = pos.method_10260() - cZ)) {
            instance.tick();
        }
    }

    public void beginFrame(TaskEngine taskEngine, class_4184 info) {
        this.frame.tick();
        this.processQueuedAdditions();
        Vector3f look = info.method_19335();
        float lookX = look.x();
        float lookY = look.y();
        float lookZ = look.z();
        int cX = (int)info.method_19326().field_1352;
        int cY = (int)info.method_19326().field_1351;
        int cZ = (int)info.method_19326().field_1350;
        ArrayList instances = new ArrayList(this.dynamicInstances.values());
        int incr = 500;
        int size = instances.size();
        for (int start = 0; start < size; start += incr) {
            int end = Math.min(start + incr, size);
            List sub = instances.subList(start, end);
            taskEngine.submit(() -> {
                for (DynamicInstance dyn : sub) {
                    this.updateInstance(dyn, lookX, lookY, lookZ, cX, cY, cZ);
                }
            });
        }
    }

    protected void updateInstance(DynamicInstance dyn, float lookX, float lookY, float lookZ, int cX, int cY, int cZ) {
        int dZ;
        int dY;
        int dist;
        if (!dyn.decreaseFramerateWithDistance()) {
            dyn.beginFrame();
            return;
        }
        class_2338 worldPos = dyn.getWorldPosition();
        int dX = worldPos.method_10263() - cX;
        float dot = ((float)dX + lookX * (float)(dist = 2)) * lookX + ((float)(dY = worldPos.method_10264() - cY) + lookY * (float)dist) * lookY + ((float)(dZ = worldPos.method_10260() - cZ) + lookZ * (float)dist) * lookZ;
        if (dot < 0.0f) {
            return;
        }
        if (this.frame.shouldUpdate(dX, dY, dZ)) {
            dyn.beginFrame();
        }
    }

    public void add(T obj) {
        if (!Backend.isOn()) {
            return;
        }
        if (this.canInstance(obj)) {
            this.addInternal(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAdd(T obj) {
        if (!Backend.isOn()) {
            return;
        }
        Set<T> set = this.queuedAdditions;
        synchronized (set) {
            this.queuedAdditions.add(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpdate(T obj) {
        if (!Backend.isOn()) {
            return;
        }
        Set<T> set = this.queuedUpdates;
        synchronized (set) {
            this.queuedUpdates.add(obj);
        }
    }

    public void update(T obj) {
        AbstractInstance instance;
        if (!Backend.isOn()) {
            return;
        }
        if (this.canInstance(obj) && (instance = this.getInstance(obj)) != null) {
            if (instance.shouldReset()) {
                this.removeInternal(obj, instance);
                this.createInternal(obj);
            } else {
                instance.update();
            }
        }
    }

    public void remove(T obj) {
        AbstractInstance instance;
        if (!Backend.isOn()) {
            return;
        }
        if (this.canInstance(obj) && (instance = this.getInstance(obj)) != null) {
            this.removeInternal(obj, instance);
        }
    }

    public void invalidate() {
        this.instances.values().forEach(AbstractInstance::removeAndMark);
        this.instances.clear();
        this.dynamicInstances.clear();
        this.tickableInstances.clear();
    }

    @Nullable
    protected <I extends T> AbstractInstance getInstance(I obj) {
        if (!Backend.isOn()) {
            return null;
        }
        return this.instances.get(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQueuedAdditions() {
        ArrayList<T> queued;
        if (this.queuedAdditions.isEmpty()) {
            return;
        }
        Set<T> set = this.queuedAdditions;
        synchronized (set) {
            queued = new ArrayList<T>(this.queuedAdditions);
            this.queuedAdditions.clear();
        }
        if (!queued.isEmpty()) {
            queued.forEach(this::addInternal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQueuedUpdates() {
        ArrayList<T> queued;
        Set<T> set = this.queuedUpdates;
        synchronized (set) {
            queued = new ArrayList<T>(this.queuedUpdates);
            this.queuedUpdates.clear();
        }
        if (queued.size() > 0) {
            queued.forEach(this::update);
        }
    }

    protected void addInternal(T obj) {
        if (!Backend.isOn()) {
            return;
        }
        AbstractInstance instance = this.instances.get(obj);
        if (instance == null && this.canCreateInstance(obj)) {
            this.createInternal(obj);
        }
    }

    protected void removeInternal(T obj, AbstractInstance instance) {
        instance.removeAndMark();
        this.instances.remove(obj);
        this.dynamicInstances.remove(obj);
        this.tickableInstances.remove(obj);
        LightUpdater.get((class_1936)instance.world).removeListener(instance);
    }

    @Nullable
    protected AbstractInstance createInternal(T obj) {
        AbstractInstance renderer = this.createRaw(obj);
        if (renderer != null) {
            Instance r;
            renderer.init();
            renderer.updateLight();
            LightUpdater.get((class_1936)renderer.world).addListener(renderer);
            this.instances.put(obj, renderer);
            if (renderer instanceof TickableInstance) {
                r = (TickableInstance)((Object)renderer);
                this.tickableInstances.put(obj, (Object)r);
                r.tick();
            }
            if (renderer instanceof DynamicInstance) {
                r = (DynamicInstance)((Object)renderer);
                this.dynamicInstances.put(obj, (Object)r);
                r.beginFrame();
            }
        }
        return renderer;
    }

    @Override
    public void onOriginShift() {
        ArrayList<T> instanced = new ArrayList<T>(this.instances.keySet());
        this.invalidate();
        instanced.forEach(this::add);
    }

    public void detachLightListeners() {
        for (AbstractInstance value : this.instances.values()) {
            LightUpdater.get((class_1936)value.world).removeListener(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAddAll(Collection<? extends T> objects) {
        if (!Backend.isOn() || objects.isEmpty()) {
            return;
        }
        Set<T> set = this.queuedAdditions;
        synchronized (set) {
            this.queuedAdditions.addAll(objects);
        }
    }
}

