/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.backend.model.BufferBuilderExtension;
import com.jozufozu.flywheel.backend.model.DirectVertexConsumer;
import java.nio.ByteBuffer;
import net.minecraft.class_1921;
import net.minecraft.class_293;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.MemoryUtil;

public class DrawBuffer {
    private final class_1921 parent;
    private ByteBuffer backingBuffer;
    private int expectedVertices;

    @ApiStatus.Internal
    public DrawBuffer(class_1921 parent) {
        this.parent = parent;
    }

    public DirectVertexConsumer begin(int vertexCount) {
        if (this.expectedVertices != 0) {
            throw new IllegalStateException("Already drawing");
        }
        this.expectedVertices = vertexCount;
        class_293 format = this.parent.method_23031();
        int byteSize = format.method_1362() * (vertexCount + 1);
        if (this.backingBuffer == null) {
            this.backingBuffer = MemoryUtil.memAlloc((int)byteSize);
        }
        if (byteSize > this.backingBuffer.capacity()) {
            this.backingBuffer = MemoryUtil.memRealloc((ByteBuffer)this.backingBuffer, (int)byteSize);
        }
        return new DirectVertexConsumer(this.backingBuffer, format, vertexCount);
    }

    public void inject(BufferBuilderExtension bufferBuilder) {
        bufferBuilder.flywheel$injectForRender(this.backingBuffer, this.parent.method_23031(), this.expectedVertices);
    }

    public boolean hasVertices() {
        return this.expectedVertices > 0;
    }

    public void reset() {
        this.expectedVertices = 0;
    }
}

