/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.Instance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;

public abstract class AbstractInstance
implements Instance,
LightListener {
    protected final MaterialManager materialManager;
    public final class_1937 world;
    protected boolean removed = false;

    public AbstractInstance(MaterialManager materialManager, class_1937 world) {
        this.materialManager = materialManager;
        this.world = world;
    }

    public void init() {
    }

    public final void removeAndMark() {
        if (this.removed) {
            return;
        }
        this.remove();
        this.removed = true;
    }

    protected abstract void remove();

    public void update() {
    }

    public void updateLight() {
    }

    public boolean shouldReset() {
        return false;
    }

    @Override
    public boolean isListenerInvalid() {
        return this.removed;
    }

    @Override
    public void onLightUpdate(class_1944 type, ImmutableBox changed) {
        this.updateLight();
    }

    protected void relight(class_2338 pos, FlatLit<?> ... models) {
        this.relight(this.world.method_8314(class_1944.field_9282, pos), this.world.method_8314(class_1944.field_9284, pos), models);
    }

    protected <L extends FlatLit<?>> void relight(class_2338 pos, Stream<L> models) {
        this.relight(this.world.method_8314(class_1944.field_9282, pos), this.world.method_8314(class_1944.field_9284, pos), models);
    }

    protected void relight(int block, int sky, FlatLit<?> ... models) {
        this.relight(block, sky, Arrays.stream(models));
    }

    protected <L extends FlatLit<?>> void relight(int block, int sky, Stream<L> models) {
        models.forEach(model -> ((FlatLit)model.setBlockLight(block)).setSkyLight(sky));
    }
}

