/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.shader;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlObject;
import java.nio.FloatBuffer;
import javax.annotation.Nonnull;
import net.minecraft.class_285;
import net.minecraft.class_2960;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryStack;

public abstract class GlProgram
extends GlObject {
    private static final FloatBuffer floatBuffer = MemoryStack.stackGet().mallocFloat(16);
    public final class_2960 name;

    protected GlProgram(class_2960 name, int handle) {
        this.name = name;
        this.setHandle(handle);
    }

    public void bind() {
        class_285.method_22094((int)this.handle());
    }

    public static void unbind() {
        class_285.method_22094((int)0);
    }

    public int getUniformLocation(String uniform) {
        int index = GL20.glGetUniformLocation((int)this.handle(), (CharSequence)uniform);
        if (index < 0) {
            Backend.LOGGER.debug("No active uniform '{}' exists in program '{}'. Could be unused.", (Object)uniform, (Object)this.name);
        }
        return index;
    }

    public int setSamplerBinding(String name, int binding) {
        int samplerUniform = this.getUniformLocation(name);
        if (samplerUniform >= 0) {
            GL20.glUniform1i((int)samplerUniform, (int)binding);
        }
        return samplerUniform;
    }

    protected static void uploadMatrixUniform(int uniform, Matrix4f mat) {
        mat.get(floatBuffer);
        GL20.glUniformMatrix4fv((int)uniform, (boolean)false, (FloatBuffer)floatBuffer);
    }

    @Override
    protected void deleteInternal(int handle) {
        GL20.glDeleteProgram((int)handle);
    }

    public String toString() {
        return "program " + this.name;
    }

    public static interface Factory<P extends GlProgram> {
        @Nonnull
        public P create(class_2960 var1, int var2);
    }
}

