/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl;

import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.mojang.blaze3d.platform.GlStateManager;

public class GlStateTracker {
    private static final int[] BUFFERS = new int[GlBufferType.values().length];
    private static int vao;
    private static int program;

    public static int getBuffer(GlBufferType type) {
        return BUFFERS[type.ordinal()];
    }

    public static int getVertexArray() {
        return vao;
    }

    public static int getProgram() {
        return program;
    }

    public static void _setBuffer(GlBufferType type, int id) {
        GlStateTracker.BUFFERS[type.ordinal()] = id;
    }

    public static void _setVertexArray(int id) {
        vao = id;
    }

    public static void _setProgram(int id) {
        program = id;
    }

    public static State getRestoreState() {
        return new State((int[])BUFFERS.clone(), vao, program);
    }

    public record State(int[] buffers, int vao, int program) {
        public void restore() {
            if (this.vao != vao) {
                GlStateManager._glBindVertexArray((int)this.vao);
            }
            GlBufferType[] values = GlBufferType.values();
            for (int i = 0; i < values.length; ++i) {
                if (this.buffers[i] == BUFFERS[i] || values[i] == GlBufferType.ELEMENT_ARRAY_BUFFER) continue;
                GlStateManager._glBindBuffer((int)values[i].glEnum, (int)this.buffers[i]);
            }
            if (this.program != program) {
                GlStateManager._glUseProgram((int)this.program);
            }
        }
    }
}

