/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.jozufozu.flywheel.Flywheel;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.jozufozu.flywheel.core.GameStateRegistry;
import com.jozufozu.flywheel.core.crumbling.CrumblingRenderer;
import com.jozufozu.flywheel.core.shader.ProgramSpec;
import com.jozufozu.flywheel.core.source.Resolver;
import com.jozufozu.flywheel.core.source.ShaderSources;
import com.jozufozu.flywheel.event.GatherContextEvent;
import com.jozufozu.flywheel.fabric.event.EventContext;
import com.jozufozu.flywheel.fabric.event.FlywheelEvents;
import com.jozufozu.flywheel.util.ResourceUtil;
import com.jozufozu.flywheel.util.StringUtil;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_638;

public class Loader {
    public static final String PROGRAM_DIR = "flywheel/programs";
    public static final String PROGRAM_DIR_SLASH = "flywheel/programs/";
    private static final Gson GSON = new GsonBuilder().create();
    private final Map<class_2960, ProgramSpec> programs = new HashMap<class_2960, ProgramSpec>();
    private boolean firstLoad = true;

    Loader() {
        ResourceReloadListener.INSTANCE.addCallback(this::onResourceManagerReload);
    }

    @Nullable
    public ProgramSpec get(class_2960 name) {
        return this.programs.get(name);
    }

    public void onResourceManagerReload(class_3300 manager) {
        Backend.refresh();
        GameStateRegistry._clear();
        Resolver.INSTANCE.invalidate();
        ((EventContext.Listener)FlywheelEvents.GATHER_CONTEXT.invoker()).handleEvent(new GatherContextEvent(this.firstLoad));
        ShaderSources sources = new ShaderSources(manager);
        this.loadProgramSpecs(manager);
        Resolver.INSTANCE.run(sources);
        Backend.LOGGER.info("Loaded all shader sources.");
        class_638 world = class_310.method_1551().field_1687;
        if (Backend.canUseInstancing((class_1937)world)) {
            InstancedRenderDispatcher.resetInstanceWorld(world);
            CrumblingRenderer.reset();
        }
        this.firstLoad = false;
    }

    private void loadProgramSpecs(class_3300 manager) {
        this.programs.clear();
        Map programSpecs = manager.method_14488(PROGRAM_DIR, loc -> loc.method_12832().endsWith(".json"));
        programSpecs.forEach((location, resource) -> {
            try (InputStream inputStream = resource.method_14482();){
                String s = StringUtil.readToString(inputStream);
                class_2960 specName = ResourceUtil.trim(location, PROGRAM_DIR_SLASH, ".json");
                DataResult result = ProgramSpec.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson(s, JsonElement.class)));
                ProgramSpec spec = (ProgramSpec)((Pair)result.get().orThrow()).getFirst();
                spec.setName(specName);
                if (this.programs.containsKey(specName)) {
                    throw new IllegalStateException("Program spec '" + specName + "' already registered.");
                }
                this.programs.put(specName, spec);
            }
            catch (Exception e) {
                Backend.LOGGER.error("Could not load program " + location, (Throwable)e);
            }
        });
    }

    public static class ResourceReloadListener
    implements class_4013,
    IdentifiableResourceReloadListener {
        public static final ResourceReloadListener INSTANCE = new ResourceReloadListener();
        public static final class_2960 ID = Flywheel.rl("loaders");
        public static final List<class_2960> DEPENDENCIES = List.of(ResourceReloadListenerKeys.TEXTURES, ResourceReloadListenerKeys.MODELS);
        private final List<Consumer<class_3300>> callbacks = new ArrayList<Consumer<class_3300>>();

        public void method_14491(class_3300 resourceManager) {
            this.callbacks.forEach(callback -> callback.accept(resourceManager));
        }

        public class_2960 getFabricId() {
            return ID;
        }

        public List<class_2960> getFabricDependencies() {
            return DEPENDENCIES;
        }

        protected void addCallback(Consumer<class_3300> callback) {
            this.callbacks.add(callback);
        }
    }
}

