/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.border;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.lambdaurora.spruceui.border.Border;
import dev.lambdaurora.spruceui.util.ColorUtil;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import java.util.Arrays;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_757;

public final class SimpleBorder
implements Border {
    public static final SimpleBorder SIMPLE_BORDER = new SimpleBorder(1, 192, 192, 192, 255);
    private final int thickness;
    private final int[] color;
    private final int[] focusedColor;

    public SimpleBorder(int thickness, int color) {
        this(thickness, color, color);
    }

    public SimpleBorder(int thickness, int color, int focusedColor) {
        this.thickness = thickness;
        this.color = ColorUtil.unpackARGBColor(color);
        this.focusedColor = ColorUtil.unpackARGBColor(focusedColor);
    }

    public SimpleBorder(int thickness, int red, int green, int blue, int alpha) {
        this(thickness, red, green, blue, alpha, red, green, blue, alpha);
    }

    public SimpleBorder(int thickness, int red, int green, int blue, int alpha, int focusedRed, int focusedGreen, int focusedBlue, int focusedAlpha) {
        this.thickness = thickness;
        this.color = new int[]{red, green, blue, alpha};
        this.focusedColor = new int[]{focusedRed, focusedGreen, focusedBlue, focusedAlpha};
    }

    @Override
    public void render(class_332 graphics, SpruceWidget widget, int mouseX, int mouseY, float delta) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        int x = widget.getX();
        int y = widget.getY();
        int right = x + widget.getWidth();
        int bottom = y + widget.getHeight();
        boolean focused = widget.method_25370();
        this.vertex(buffer, x, y + this.thickness, focused);
        this.vertex(buffer, right, y + this.thickness, focused);
        this.vertex(buffer, right, y, focused);
        this.vertex(buffer, x, y, focused);
        this.vertex(buffer, right - this.thickness, bottom, focused);
        this.vertex(buffer, right, bottom, focused);
        this.vertex(buffer, right, y, focused);
        this.vertex(buffer, right - this.thickness, y, focused);
        this.vertex(buffer, x, bottom, focused);
        this.vertex(buffer, right, bottom, focused);
        this.vertex(buffer, right, bottom - this.thickness, focused);
        this.vertex(buffer, x, bottom - this.thickness, focused);
        this.vertex(buffer, x, bottom, focused);
        this.vertex(buffer, x + this.thickness, bottom, focused);
        this.vertex(buffer, x + this.thickness, y, focused);
        this.vertex(buffer, x, y, focused);
        tessellator.method_1350();
    }

    private void vertex(class_287 buffer, int x, int y, boolean focused) {
        int[] color = focused ? this.focusedColor : this.color;
        buffer.method_22912((double)x, (double)y, 0.0).method_1336(color[0], color[1], color[2], color[3]).method_1344();
    }

    @Override
    public int getThickness() {
        return this.thickness;
    }

    public String toString() {
        return "SimpleBorder{thickness=" + this.thickness + ", color=" + Arrays.toString(this.color) + ", focusedColor=" + Arrays.toString(this.focusedColor) + "}";
    }
}

