/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.versionTracker.v1;

import de.sakurajin.sakuralib.SakuraLib;
import de.sakurajin.sakuralib.util.v1.MetadataHelper;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3545;

public class ModVersionTracker {
    public static final ModVersionTracker INSTANCE = new ModVersionTracker(false);
    private final HashMap<String, class_3545<Integer, Version>> loadedModVersions = new HashMap();
    private class_2487 oldNbtData = null;

    private ModVersionTracker(boolean fromNbt) {
        if (!fromNbt) {
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                int formatVersion = MetadataHelper.getCustomOrDefault(mod.getMetadata().getId(), "sakuralib:format_version", 0);
                Version modVersion = mod.getMetadata().getVersion();
                this.loadedModVersions.put(mod.getMetadata().getId(), (class_3545<Integer, Version>)new class_3545((Object)formatVersion, (Object)modVersion));
                SakuraLib.DATAGEN_CONTAINER.LOGGER.debug("mod " + mod.getMetadata().getId() + " has format version " + formatVersion);
            }
        }
    }

    public static void init() {
    }

    public static ModVersionTracker createFromNbt(class_2487 tag) throws VersionParsingException {
        ModVersionTracker tracker = new ModVersionTracker(true);
        tracker.oldNbtData = tag.method_10562("versiondata");
        for (String entry : tracker.oldNbtData.method_10541()) {
            Version modVersion;
            int formatVersion;
            class_2487 modNbt = tracker.oldNbtData.method_10562(entry);
            try {
                formatVersion = modNbt.method_10550("format_version");
            }
            catch (Exception e) {
                SakuraLib.DATAGEN_CONTAINER.LOGGER.error("error while parsing mod format version for mod " + entry, (Throwable)e);
                formatVersion = 0;
            }
            try {
                modVersion = Version.parse((String)modNbt.method_10558("mod_version"));
            }
            catch (Exception e) {
                SakuraLib.DATAGEN_CONTAINER.LOGGER.error("error while parsing mod version for mod " + entry, (Throwable)e);
                modVersion = null;
            }
            tracker.loadedModVersions.put(entry, (class_3545<Integer, Version>)new class_3545((Object)formatVersion, (Object)modVersion));
        }
        return tracker;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        class_2487 versiondata = new class_2487();
        for (Map.Entry<String, class_3545<Integer, Version>> entry : this.loadedModVersions.entrySet()) {
            class_2487 modNbt = new class_2487();
            modNbt.method_10569("format_version", ((Integer)entry.getValue().method_15442()).intValue());
            modNbt.method_10582("mod_version", ((Version)entry.getValue().method_15441()).getFriendlyString());
            versiondata.method_10566(entry.getKey(), (class_2520)modNbt);
        }
        nbt.method_10566("versiondata", (class_2520)versiondata);
        return nbt;
    }

    public static HashMap<String, class_3545<class_3545<Version, Version>, class_3545<Integer, Integer>>> getDifference(ModVersionTracker oldData, ModVersionTracker newData) {
        HashMap<String, class_3545<class_3545<Version, Version>, class_3545<Integer, Integer>>> difference = new HashMap<String, class_3545<class_3545<Version, Version>, class_3545<Integer, Integer>>>();
        for (Map.Entry<String, class_3545<Integer, Version>> entry : oldData.loadedModVersions.entrySet()) {
            class_3545<Integer, Version> newEntry = newData.loadedModVersions.getOrDefault(entry.getKey(), (class_3545<Integer, Version>)new class_3545((Object)0, null));
            int oldFormat = (Integer)entry.getValue().method_15442();
            int newFormat = (Integer)newEntry.method_15442();
            Version oldVersion = (Version)entry.getValue().method_15441();
            Version newVersion = (Version)newEntry.method_15441();
            if (oldFormat == newFormat && newVersion != null && oldVersion.compareTo((Object)newVersion) == 0) continue;
            difference.put(entry.getKey(), (class_3545<class_3545<Version, Version>, class_3545<Integer, Integer>>)new class_3545((Object)new class_3545((Object)oldVersion, (Object)newVersion), (Object)new class_3545((Object)oldFormat, (Object)newFormat)));
        }
        return difference;
    }

    public static HashMap<String, class_3545<class_3545<Version, Version>, class_3545<Integer, Integer>>> getDifference(ModVersionTracker oldData) {
        return ModVersionTracker.getDifference(oldData, INSTANCE);
    }

    public static int getFormatVersion(String modID) {
        return (Integer)ModVersionTracker.INSTANCE.loadedModVersions.getOrDefault(modID, (class_3545<Integer, Version>)new class_3545((Object)0, null)).method_15442();
    }

    public static Version getModVersion(String modID) {
        return (Version)ModVersionTracker.INSTANCE.loadedModVersions.getOrDefault(modID, (class_3545<Integer, Version>)new class_3545((Object)0, null)).method_15441();
    }
}

