/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.util.v1;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.util.v1.GenericsHelper;
import de.sakurajin.sakuralib.util.v1.JsonObjectBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class SakuraJsonHelper {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static String toPrettyJson(JsonElement element) {
        return GSON.toJson(element);
    }

    public static byte[] toPrettyBytes(JsonElement element) {
        return GSON.toJson(element).getBytes(StandardCharsets.UTF_8);
    }

    @SafeVarargs
    public static <T> JsonArray createArray(T ... elements) {
        JsonArray array = new JsonArray();
        for (T element : elements) {
            try {
                SakuraJsonHelper.addToJsonArray(array, element);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The given element is not a valid json element");
            }
        }
        return array;
    }

    public static <T> void addToJsonArray(JsonArray array, T data) {
        if (data instanceof String) {
            array.add((String)data);
        } else if (GenericsHelper.isNumber(data)) {
            array.add((Number)data);
        } else if (data instanceof Boolean) {
            array.add((Boolean)data);
        } else if (data instanceof Character) {
            array.add((Character)data);
        } else if (data instanceof JsonObjectBuilder) {
            array.add((JsonElement)((JsonObjectBuilder)data).build());
        } else {
            try {
                array.add((JsonElement)data);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The given element is not a valid json element");
            }
        }
    }

    public static JsonObject merge(JsonObject ... objects) {
        JsonObject merged = new JsonObject();
        for (JsonObject object : objects) {
            if (object == null) continue;
            for (Map.Entry entry : object.entrySet()) {
                merged.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        return merged;
    }
}

