/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.util.v1;

import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;

public class MetadataHelper {
    public static <T> T getCustomOrDefault(String modID, String key, T defaultValue) {
        String[] keys = key.split(":");
        Optional container = FabricLoader.getInstance().getModContainer(modID);
        if (container.isEmpty()) {
            return defaultValue;
        }
        CustomValue customValue = ((ModContainer)container.get()).getMetadata().getCustomValue(keys[0]);
        if (customValue == null || customValue.getType() != CustomValue.CvType.OBJECT) {
            return defaultValue;
        }
        CustomValue.CvObject customObject = customValue.getAsObject();
        for (int i = 1; i < keys.length - 1; ++i) {
            customValue = customObject.get(keys[i]);
            if (customValue == null || customValue.getType() != CustomValue.CvType.OBJECT) {
                return defaultValue;
            }
            customObject = customValue.getAsObject();
        }
        customValue = customObject.get(keys[keys.length - 1]);
        if (customValue == null) {
            return defaultValue;
        }
        try {
            if (defaultValue.getClass() == Boolean.class) {
                return (T)Boolean.valueOf(customValue.getAsBoolean());
            }
            if (defaultValue.getClass() == Integer.class) {
                return (T)Integer.valueOf(customValue.getAsNumber().intValue());
            }
            if (defaultValue.getClass() == Double.class) {
                return (T)Double.valueOf(customValue.getAsNumber().doubleValue());
            }
            if (defaultValue.getClass() == Long.class) {
                return (T)Long.valueOf(customValue.getAsNumber().longValue());
            }
            if (defaultValue.getClass() == Float.class) {
                return (T)Float.valueOf(customValue.getAsNumber().floatValue());
            }
            if (defaultValue.getClass() == String.class) {
                return (T)customValue.getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

