/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.util.v1;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class JsonObjectBuilder {
    private final JsonObject jsonObject = new JsonObject();

    private JsonObjectBuilder() {
    }

    public static JsonObjectBuilder create() {
        return new JsonObjectBuilder();
    }

    public JsonObjectBuilder add(String property, JsonElement value) {
        this.jsonObject.add(property, value);
        return this;
    }

    public JsonObjectBuilder add(String property, String value) {
        this.jsonObject.addProperty(property, value);
        return this;
    }

    public JsonObjectBuilder add(String property, Number value) {
        this.jsonObject.addProperty(property, value);
        return this;
    }

    public JsonObjectBuilder add(String property, Boolean value) {
        this.jsonObject.addProperty(property, value);
        return this;
    }

    public JsonObjectBuilder add(String property, Character value) {
        this.jsonObject.addProperty(property, value);
        return this;
    }

    public <T> JsonObjectBuilder addGeneric(String property, T value) {
        if (value instanceof JsonElement) {
            this.add(property, (JsonElement)value);
        } else if (value instanceof String) {
            this.add(property, (String)value);
        } else if (value instanceof Number) {
            this.add(property, (Number)value);
        } else if (value instanceof Boolean) {
            this.add(property, (Boolean)value);
        } else if (value instanceof Character) {
            this.add(property, (Character)value);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName());
        }
        return this;
    }

    public JsonObject build() {
        return this.jsonObject.deepCopy();
    }
}

