/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.loot.v2.table_insert;

import de.sakurajin.sakuralib.SakuraLib;
import de.sakurajin.sakuralib.loot.v2.LootSourceHelper;
import de.sakurajin.sakuralib.loot.v2.table_insert.LootEntryInsert;
import de.sakurajin.sakuralib.loot.v2.table_insert.LootTableEntryProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.loot.v2.FabricLootPoolBuilder;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_60;

public class LootTableInsertManager {
    private static final HashMap<class_2960, ArrayList<LootTableEntryProvider>> LootTableEntryProviders = new HashMap();
    static boolean isInitialized = false;

    public static void init() {
        if (isInitialized) {
            return;
        }
        LootTableEvents.MODIFY.register(LootTableInsertManager::LootTableEventHandler);
        isInitialized = true;
    }

    private static void LootTableEventHandler(class_3300 resourceManager, class_60 lootManager, class_2960 tableID, class_52.class_53 tableBuilder, LootTableSource tableSource) {
        if (!LootTableEntryProviders.containsKey(tableID)) {
            return;
        }
        SakuraLib.DATAGEN_CONTAINER.LOGGER.debug("Injecting loot table entries into loot table: " + tableID.toString());
        ArrayList<LootTableEntryProvider> lootTableEntryProviders = LootTableEntryProviders.get(tableID);
        List lootPools = tableBuilder.field_949;
        for (LootTableEntryProvider entryProvider : lootTableEntryProviders) {
            ArrayList<LootEntryInsert> injections = entryProvider.getInsertions();
            for (LootEntryInsert injection : injections) {
                int lootPoolIndex = injection.poolIndex;
                if (lootPoolIndex >= lootPools.size() || injection.entry == null || !LootSourceHelper.inNumber(injection.lootSources, tableSource)) continue;
                class_55.class_56 lootPoolBuilder = FabricLootPoolBuilder.copyOf((class_55)((class_55)lootPools.get(lootPoolIndex))).with(injection.entry);
                lootPools.set(lootPoolIndex, lootPoolBuilder.method_355());
            }
        }
    }

    public static void addProvider(class_2960 lootTableID, LootTableEntryProvider ... providers) {
        ArrayList<LootTableEntryProvider> providerList = LootTableEntryProviders.getOrDefault(lootTableID, new ArrayList());
        providerList.addAll(Arrays.asList(providers));
        LootTableEntryProviders.put(lootTableID, providerList);
    }
}

