/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.loot.v2.distribution;

import java.util.ArrayList;
import java.util.HashMap;

public class PowerDistribution {
    static final HashMap<Integer, HashMap<Integer, ArrayList<Double>>> DistributionCache = new HashMap();

    public static ArrayList<Double> GetDistribution(int order, int elementCount) throws IllegalArgumentException {
        if (elementCount <= 0) {
            throw new IllegalArgumentException("elementCount must be greater than 0");
        }
        HashMap orderMap = DistributionCache.getOrDefault(order, new HashMap());
        ArrayList<Double> elementMap = orderMap.getOrDefault(elementCount, new ArrayList());
        if (elementMap.isEmpty()) {
            int i;
            double totalWeight = 0.0;
            for (i = 0; i < elementCount; ++i) {
                totalWeight += Math.pow(elementCount - i, order);
            }
            for (i = 0; i < elementCount; ++i) {
                elementMap.add(Math.pow(elementCount - i, order) / totalWeight);
            }
            orderMap.put(elementCount, elementMap);
            DistributionCache.put(order, orderMap);
        }
        return elementMap;
    }
}

