/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.loot.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;

public class LootSourceHelper {
    public static final int VANILLA = 1;
    public static final int MOD = 2;
    public static final int DATA_PACK = 4;
    public static final int REPLACED = 8;
    public static final int BUILTIN = 3;
    public static final int ADDITIONS = 7;
    public static final int ALL = 15;
    public static final Map<LootTableSource, Integer> sourceIDMap = Map.of(LootTableSource.VANILLA, 1, LootTableSource.MOD, 2, LootTableSource.DATA_PACK, 4, LootTableSource.REPLACED, 8);

    public static int getNumberFor(LootTableSource ... sources) {
        int id = 0;
        for (LootTableSource source : sources) {
            id |= sourceIDMap.get(source).intValue();
        }
        return id;
    }

    public static List<LootTableSource> getSources(int id) {
        ArrayList<LootTableSource> sources = new ArrayList<LootTableSource>();
        for (LootTableSource source : sourceIDMap.keySet()) {
            if (!LootSourceHelper.inNumber(id, source)) continue;
            sources.add(source);
        }
        return sources;
    }

    public static boolean inNumber(int number, LootTableSource source) {
        return (number & sourceIDMap.get(source)) != 0;
    }
}

